/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.management;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.Migration;
import org.nuxeo.runtime.migration.MigrationService;

@WebObject(type="management/migration")
@Produces(value={"application/json"})
public class MigrationObject
extends AbstractResource<ResourceTypeImpl> {
    @GET
    @Path(value="{migrationId}")
    public Migration doGet(@PathParam(value="migrationId") String migrationId) {
        return ((MigrationService)Framework.getService(MigrationService.class)).getMigration(migrationId);
    }

    @GET
    public List<Migration> doGetList() {
        return ((MigrationService)Framework.getService(MigrationService.class)).getMigrations();
    }

    @POST
    @Path(value="{migrationId}/probe")
    public Migration doProbe(@PathParam(value="migrationId") String migrationId) {
        ((MigrationService)Framework.getService(MigrationService.class)).probeAndSetState(migrationId);
        return this.doGet(migrationId);
    }

    @POST
    @Path(value="{migrationId}/run")
    public Response doRun(@PathParam(value="migrationId") String migrationId) {
        ((MigrationService)Framework.getService(MigrationService.class)).probeAndRun(migrationId);
        return Response.status((int)202).build();
    }

    @POST
    @Path(value="{migrationId}/run/{stepId}")
    public Response doRun(@PathParam(value="migrationId") String migrationId, @PathParam(value="stepId") String stepId) {
        ((MigrationService)Framework.getService(MigrationService.class)).runStep(migrationId, stepId);
        return Response.status((int)202).build();
    }
}

