/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import com.ibm.icu.text.CharsetDetector;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;

public class PlainTextPreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    public String htmlContent(String content) {
        String escaped = StringUtils.replaceEach((String)content, (String[])new String[]{"&", "<", "\n"}, (String[])new String[]{"&amp;", "&lt;", "<br/>"});
        return "<pre>" + escaped + "</pre>";
    }

    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        String content;
        byte[] data;
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        try {
            data = blob.getByteArray();
        }
        catch (IOException e) {
            throw new PreviewException("Cannot fetch blob content", e);
        }
        String encoding = blob.getEncoding();
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(data);
            encoding = detector.detect().getName();
        }
        try {
            content = new String(data, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PreviewException("Cannot encode blob content to string", e);
        }
        String html = PreviewHelper.makeHtmlPage(this.htmlContent(content));
        Blob mainBlob = Blobs.createBlob((String)html, (String)"text/html", (String)"UTF-8", (String)"index.html");
        blobResults.add(mainBlob);
        return blobResults;
    }
}

