/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.htmlsanitizer.HtmlSanitizerService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ZipPreviewer
implements MimeTypePreviewer {
    private static final Logger log = LogManager.getLogger(ZipPreviewer.class);
    protected static final String SANITIZE_ZIP_PREVIEW = "nuxeo.preview.zip.sanitize.enabled";
    protected static final Set<String> HTML_MIME_TYPES = Set.of("text/html", "text/xml", "text/plain");

    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        String converterName = conversionService.getConverterName("application/zip", "text/html");
        if (converterName == null) {
            throw new PreviewException("Unable to find converter from application/zip to text/html");
        }
        try {
            BlobHolder result = conversionService.convert(converterName, (BlobHolder)new SimpleBlobHolder(blob), null);
            List blobs = result.getBlobs();
            if (((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanTrue(SANITIZE_ZIP_PREVIEW)) {
                blobs.replaceAll(this::sanitize);
            }
            return blobs;
        }
        catch (ConversionException e) {
            throw new PreviewException(e.getMessage(), e);
        }
    }

    protected Blob sanitize(Blob blob) {
        String filename = blob.getFilename();
        if (!this.isSanitizable(blob)) {
            log.debug("ZipEntryBlob: {} is not sanitizable", (Object)filename);
            return blob;
        }
        HtmlSanitizerService sanitizerService = (HtmlSanitizerService)Framework.getService(HtmlSanitizerService.class);
        try {
            String content = blob.getString();
            content = sanitizerService.sanitizeString(content, null);
            content = PreviewHelper.makeHtmlPage(content);
            return Blobs.createBlob((String)content, (String)"text/html", null, (String)filename);
        }
        catch (IOException e) {
            throw new PreviewException("Cannot read ZipEntryBlob content with filename: " + filename, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSanitizable(Blob blob) {
        MimetypeRegistry registry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimeType = registry.getMimetypeFromFilenameWithBlobMimetypeFallback(blob.getFilename(), blob, null);
        if (mimeType != null) return HTML_MIME_TYPES.contains(mimeType);
        try (InputStream stream = blob.getStream();){
            LineIterator lineIt = IOUtils.lineIterator((InputStream)stream, (String)((String)ObjectUtils.defaultIfNull((Object)blob.getEncoding(), (Object)"UTF-8")));
            while (lineIt.hasNext()) {
                String line = lineIt.nextLine();
                if (!line.contains("<script")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new PreviewException("Unable to introspect content");
        }
    }
}

