/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.service.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.suggestbox.service.descriptors.SuggesterGroupItemDescriptor;

@XObject(value="suggesterGroup")
@XRegistry
public class SuggesterGroupDescriptor {
    private static final Log log = LogFactory.getLog(SuggesterGroupDescriptor.class);
    @XNode(value="@name")
    @XRegistryId
    protected String name = "default";
    @XNodeList(value="suggesters/suggesterName", type=ArrayList.class, componentType=SuggesterGroupItemDescriptor.class)
    protected List<SuggesterGroupItemDescriptor> suggesters;

    public String getName() {
        return this.name;
    }

    public List<SuggesterGroupItemDescriptor> getSuggesters() {
        return Collections.unmodifiableList(this.suggesters);
    }

    public void mergeFrom(SuggesterGroupDescriptor newDescriptor) {
        if (this.name == null || !this.name.equals(newDescriptor.name)) {
            throw new RuntimeException("Cannot merge descriptor with name '" + this.name + "' with another descriptor with different name " + newDescriptor.getName() + "'");
        }
        log.info((Object)String.format("Merging suggester group '%s'.", this.name));
        for (SuggesterGroupItemDescriptor newSuggesterGroupItem : newDescriptor.getSuggesters()) {
            boolean isSuggesterAppended;
            String newSuggesterName = newSuggesterGroupItem.getName();
            if (newSuggesterGroupItem.isRemove()) {
                boolean isSuggesterRemoved = this.remove(newSuggesterName);
                if (isSuggesterRemoved) continue;
                log.warn((Object)String.format("Cannot remove suggester '%s' because it does not exist in suggesterGroup '%s'.", newSuggesterName, this.name));
                continue;
            }
            String appendBeforeSuggesterName = newSuggesterGroupItem.getAppendBefore();
            String appendAfterSuggesterName = newSuggesterGroupItem.getAppendAfter();
            if (appendBeforeSuggesterName != null && appendAfterSuggesterName != null) {
                throw new RuntimeException(String.format("Cannot define both 'appendBefore' and 'appendAfter' attributes on suggester '%s'.", newSuggesterName));
            }
            if (appendBeforeSuggesterName != null) {
                isSuggesterAppended = this.appendBefore(appendBeforeSuggesterName, newSuggesterName);
                if (isSuggesterAppended) continue;
                this.logExistingSuggesterName(newSuggesterName);
                continue;
            }
            if (appendAfterSuggesterName != null) {
                isSuggesterAppended = this.appendAfter(appendAfterSuggesterName, newSuggesterName);
                if (isSuggesterAppended) continue;
                this.logExistingSuggesterName(newSuggesterName);
                continue;
            }
            isSuggesterAppended = this.appendAfter(null, newSuggesterName);
            if (isSuggesterAppended) continue;
            this.logExistingSuggesterName(newSuggesterName);
        }
    }

    protected boolean remove(String suggesterName) {
        Iterator<SuggesterGroupItemDescriptor> suggestersIt = this.suggesters.iterator();
        while (suggestersIt.hasNext()) {
            SuggesterGroupItemDescriptor suggesterGroupItem = suggestersIt.next();
            if (!suggesterName.equals(suggesterGroupItem.getName())) continue;
            suggestersIt.remove();
            log.debug((Object)String.format("Removed suggester '%s' from suggesterGroup '%s'.", suggesterName, this.name));
            return true;
        }
        return false;
    }

    protected int indexOf(String suggesterName) {
        if (suggesterName != null) {
            int index = 0;
            for (SuggesterGroupItemDescriptor suggesterGroupItem : this.suggesters) {
                if (suggesterName.equals(suggesterGroupItem.getName())) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    protected boolean appendBefore(String suggesterName, String newSuggesterName) {
        return this.append(suggesterName, newSuggesterName, true);
    }

    protected boolean appendAfter(String suggesterName, String newSuggesterName) {
        return this.append(suggesterName, newSuggesterName, false);
    }

    protected boolean append(String suggesterName, String newSuggesterName, boolean before) {
        if (this.indexOf(newSuggesterName) > -1) {
            return false;
        }
        SuggesterGroupItemDescriptor newSuggester = new SuggesterGroupItemDescriptor(newSuggesterName);
        int indexOfSuggester = this.indexOf(suggesterName);
        if (indexOfSuggester > -1) {
            int indexOfNewSuggester = before ? indexOfSuggester : indexOfSuggester + 1;
            this.suggesters.add(indexOfNewSuggester, newSuggester);
            log.debug((Object)String.format("Appended suggester '%s' %s suggester '%s' in suggesterGroup '%s'.", newSuggesterName, before ? "before" : "after", suggesterName, this.name));
        } else if (before) {
            this.suggesters.add(0, newSuggester);
            if (suggesterName != null) {
                log.warn((Object)String.format("Could not append suggester '%s' before suggester '%s' in suggesterGroup '%s' because '%s' does not exist in this suggesterGroup. Appended it before all suggesters.", newSuggesterName, suggesterName, this.name, suggesterName));
            }
        } else {
            this.suggesters.add(newSuggester);
            if (suggesterName != null) {
                log.warn((Object)String.format("Could not append suggester '%s' after suggester '%s' in suggesterGroup '%s' because '%s' does not exist in this suggesterGroup. Appended it after all suggesters.", newSuggesterName, suggesterName, this.name, suggesterName));
            }
        }
        return true;
    }

    protected void logExistingSuggesterName(String newSuggesterName) {
        log.warn((Object)String.format("Suggester '%s' already exists in suggesterGroup '%s'. Cannot have two occurrences of the same suggester, so won't append it.", newSuggesterName, this.name));
    }
}

