/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.client.model.Filters;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepository;

public class MongoDBConverter {
    protected final String idKey;
    protected final Set<String> trueOrNullBooleanKeys;
    protected final Set<String> idValuesKeys;
    protected static final Pattern HEX_RE = Pattern.compile("[0-9a-f]{16}");

    public MongoDBConverter() {
        this(null, Set.of(), Set.of());
    }

    public MongoDBConverter(String idKey, Set<String> trueOrNullBooleanKeys, Set<String> idValuesKeys) {
        this.idKey = idKey;
        this.trueOrNullBooleanKeys = trueOrNullBooleanKeys;
        this.idValuesKeys = idValuesKeys;
    }

    public List<Document> diffToBson(State.StateDiff diff) {
        UpdateBuilder updateBuilder = new UpdateBuilder();
        return updateBuilder.build(diff);
    }

    public void putToBson(Document doc, String key, Object value) {
        doc.put(this.keyToBson(key), this.valueToBson(key, value));
    }

    public String keyToBson(String key) {
        if (this.idKey == null) {
            return key;
        }
        return this.idKey.equals(key) ? "_id" : key;
    }

    public Object valueToBson(String key, Object value) {
        if (value instanceof State) {
            return this.stateToBson((State)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            return this.listToBson(key, values);
        }
        if (value instanceof Object[]) {
            return this.listToBson(key, Arrays.asList((Object[])value));
        }
        return this.serializableToBson(key, value);
    }

    public Document stateToBson(State state) {
        Document doc = new Document();
        for (Map.Entry en : state.entrySet()) {
            Serializable value = (Serializable)en.getValue();
            if (value == null) continue;
            this.putToBson(doc, (String)en.getKey(), value);
        }
        return doc;
    }

    public <T> List<Object> listToBson(String key, Collection<T> values) {
        ArrayList<Object> objects = new ArrayList<Object>(values.size());
        for (T value : values) {
            objects.add(this.valueToBson(key, value));
        }
        return objects;
    }

    public Bson filterEq(String key, Object value) {
        return Filters.eq((String)this.keyToBson(key), (Object)this.valueToBson(key, value));
    }

    public <T> Bson filterIn(String key, Collection<T> values) {
        return Filters.in((String)this.keyToBson(key), this.listToBson(key, values));
    }

    public Serializable getFromBson(Document doc, String bsonKey, String key) {
        return this.bsonToValue(key, doc.get((Object)bsonKey));
    }

    public String bsonToKey(String key) {
        if (this.idKey == null) {
            return key;
        }
        return "_id".equals(key) ? this.idKey : key;
    }

    public State bsonToState(Document doc) {
        if (doc == null) {
            return null;
        }
        State state = new State(doc.keySet().size());
        for (String bsonKey : doc.keySet()) {
            if (this.idKey == null && "_id".equals(bsonKey)) continue;
            String key = this.bsonToKey(bsonKey);
            state.put(key, this.getFromBson(doc, bsonKey, key));
        }
        return state;
    }

    public Serializable bsonToValue(String key, Object value) {
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return null;
            }
            Class klass = Object.class;
            for (Object o : list) {
                if (o == null) continue;
                klass = this.bsonToSerializableClass(key, o.getClass());
                break;
            }
            if (Document.class.isAssignableFrom(klass)) {
                ArrayList<State> l = new ArrayList<State>(list.size());
                for (Object el : list) {
                    l.add(this.bsonToState((Document)el));
                }
                return l;
            }
            Object[] ar = (Object[])Array.newInstance(klass, list.size());
            int i = 0;
            for (Object el : list) {
                ar[i++] = this.bsonToSerializable(key, el);
            }
            return ar;
        }
        if (value instanceof Document) {
            return this.bsonToState((Document)value);
        }
        return this.bsonToSerializable(key, value);
    }

    protected boolean valueIsId(String key) {
        return key != null && this.idValuesKeys.contains(key);
    }

    public Object serializableToBson(String key, Object value) {
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (this.valueIsId(key)) {
            return this.idToBson(value);
        }
        if (Boolean.FALSE.equals(value) && key != null && this.trueOrNullBooleanKeys.contains(key)) {
            return null;
        }
        return value;
    }

    public Serializable bsonToSerializable(String key, Object val) {
        if (val instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)val);
            return cal;
        }
        if (this.valueIsId(key)) {
            return this.bsonToId(val);
        }
        return (Serializable)val;
    }

    public Class<?> bsonToSerializableClass(String key, Class<?> klass) {
        if (Date.class.isAssignableFrom(klass)) {
            return Calendar.class;
        }
        if (this.valueIsId(key)) {
            return String.class;
        }
        return klass;
    }

    protected Object idToBson(Object value) {
        if (value == null) {
            return null;
        }
        try {
            String string = (String)value;
            if (!HEX_RE.matcher(string).matches()) {
                throw new NumberFormatException(string);
            }
            return Long.parseUnsignedLong(string, 16);
        }
        catch (ClassCastException | NumberFormatException e) {
            return "__invalid_id__" + value;
        }
    }

    protected String bsonToId(Object val) {
        if (val == null) {
            return null;
        }
        try {
            Object hex = Long.toHexString((Long)val);
            int nz = 16 - ((String)hex).length();
            if (nz > 0) {
                hex = "0".repeat(nz) + (String)hex;
            }
            return hex;
        }
        catch (ClassCastException e) {
            return "__invalid_id__" + val;
        }
    }

    public class UpdateBuilder {
        protected final Document set = new Document();
        protected final Document unset = new Document();
        protected final Document push = new Document();
        protected final Document pull = new Document();
        protected final Document inc = new Document();
        protected final List<Document> updates = new ArrayList<Document>(10);
        protected Document update;
        protected Set<String> prefixKeys;
        protected Set<String> keys;

        public List<Document> build(State.StateDiff diff) {
            this.processStateDiff(diff, null);
            this.newUpdate();
            for (Map.Entry en : this.set.entrySet()) {
                this.update("$set", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.unset.entrySet()) {
                this.update("$unset", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.push.entrySet()) {
                this.update("$push", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.pull.entrySet()) {
                this.update("$pullAll", (String)en.getKey(), en.getValue());
            }
            for (Map.Entry en : this.inc.entrySet()) {
                this.update("$inc", (String)en.getKey(), en.getValue());
            }
            return this.updates;
        }

        protected void processStateDiff(State.StateDiff diff, String prefix) {
            Object elemPrefix = prefix == null ? "" : prefix + ".";
            for (Map.Entry en : diff.entrySet()) {
                String name = (String)elemPrefix + (String)en.getKey();
                Serializable value = (Serializable)en.getValue();
                if (value instanceof State.StateDiff) {
                    this.processStateDiff((State.StateDiff)value, name);
                    continue;
                }
                if (value instanceof State.ListDiff) {
                    this.processListDiff((State.ListDiff)value, name);
                    continue;
                }
                if (value instanceof Delta) {
                    this.processDelta((Delta)value, name);
                    continue;
                }
                this.processValue(name, value);
            }
        }

        protected void processListDiff(State.ListDiff listDiff, String prefix) {
            if (listDiff.diff != null) {
                Object elemPrefix = prefix == null ? "" : prefix + ".";
                int i = 0;
                for (Object value : listDiff.diff) {
                    String name = (String)elemPrefix + i;
                    if (value instanceof State.StateDiff) {
                        this.processStateDiff((State.StateDiff)value, name);
                    } else if (value != State.NOP) {
                        this.set.put(name, MongoDBConverter.this.valueToBson(prefix, value));
                    }
                    ++i;
                }
            }
            if (listDiff.rpush != null) {
                Object pushed = listDiff.rpush.size() == 1 ? MongoDBConverter.this.valueToBson(prefix, listDiff.rpush.get(0)) : new Document("$each", MongoDBConverter.this.listToBson(prefix, listDiff.rpush));
                this.push.put(prefix, pushed);
            }
            if (listDiff.pull != null) {
                this.pull.put(prefix, MongoDBConverter.this.valueToBson(prefix, listDiff.pull));
            }
        }

        protected void processDelta(Delta delta, String prefix) {
            Object incValue = MongoDBConverter.this.valueToBson(prefix, delta.getDeltaValue());
            this.inc.put(prefix, incValue);
        }

        protected void processValue(String name, Serializable value) {
            if (value == null) {
                this.unset.put(name, (Object)MongoDBRepository.ONE);
            } else {
                this.set.put(name, MongoDBConverter.this.valueToBson(name, value));
            }
        }

        protected void newUpdate() {
            this.update = new Document();
            this.updates.add(this.update);
            this.prefixKeys = new HashSet<String>();
            this.keys = new HashSet<String>();
        }

        protected void update(String op, String bsonKey, Object val) {
            this.checkForConflict(bsonKey);
            Document map = (Document)this.update.get((Object)op);
            if (map == null) {
                map = new Document();
                this.update.put(op, (Object)map);
            }
            map.put(bsonKey, val);
        }

        protected void checkForConflict(String key) {
            List<String> pKeys = this.getPrefixKeys(key);
            if (this.conflictKeys(key, pKeys)) {
                this.newUpdate();
            }
            this.prefixKeys.addAll(pKeys);
            this.keys.add(key);
        }

        protected boolean conflictKeys(String key, List<String> subkeys) {
            if (this.prefixKeys.contains(key)) {
                return true;
            }
            for (String sk : subkeys) {
                if (!this.keys.contains(sk)) continue;
                return true;
            }
            return false;
        }

        protected List<String> getPrefixKeys(String key) {
            ArrayList<String> ret = new ArrayList<String>(10);
            int i = 0;
            while ((i = key.indexOf(46, i)) > 0) {
                ret.add(key.substring(0, i++));
            }
            ret.add(key);
            return ret;
        }
    }
}

