/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.MongoClientException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.nuxeo.ecm.core.blob.DocumentBlobManager;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryBase;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConnection;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBConverter;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBCursorService;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBRepositoryDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBRepository
extends DBSRepositoryBase {
    private static final Logger log = LogManager.getLogger(MongoDBRepository.class);
    public static final String REPOSITORY_CONNECTION_PREFIX = "repository/";
    public static final Long LONG_ZERO = 0L;
    public static final Double ZERO = 0.0;
    public static final Double ONE = 1.0;
    public static final String MONGODB_ID = "_id";
    public static final String MONGODB_INC = "$inc";
    public static final String MONGODB_SET = "$set";
    public static final String MONGODB_UNSET = "$unset";
    public static final String MONGODB_PUSH = "$push";
    public static final String MONGODB_PULLALL = "$pullAll";
    public static final String MONGODB_EACH = "$each";
    public static final String MONGODB_META = "$meta";
    public static final String MONGODB_TEXT_SCORE = "textScore";
    public static final String FULLTEXT_INDEX_NAME = "fulltext";
    public static final String LANGUAGE_FIELD = "__language";
    protected static final int SEQUENCE_RANDOMIZED_BLOCKSIZE_DEFAULT = 1000;
    public static final String COUNTER_NAME_UUID = "ecm:id";
    public static final String COUNTER_FIELD = "seq";
    protected static final Duration MAX_TIME_DEFAULT = Duration.ofHours(1L);
    protected static final String SETTING_VALUE = "value";
    protected static final String SETTING_DENORMALIZED_BLOB_KEYS = "denormalizedBlobKeys";
    protected String idKey;
    protected long sequenceBlockSize;
    protected final MongoDBRepositoryDescriptor descriptor;
    protected final MongoClient mongoClient;
    protected final MongoDBConverter converter;
    protected final MongoDBCursorService cursorService;
    protected final MongoCollection<Document> coll;
    protected final MongoCollection<Document> countersColl;
    protected final MongoCollection<Document> settingsColl;
    protected final boolean supportsSessions;
    protected final boolean supportsTransactions;
    protected final long maxTimeMS;
    protected boolean supportsDenormalizedBlobKeys;
    protected Bson binaryKeys;

    public MongoDBRepository(MongoDBRepositoryDescriptor descriptor) {
        super(descriptor.name, (DBSRepositoryDescriptor)descriptor);
        boolean hasTransactions;
        boolean hasSessions;
        this.descriptor = descriptor;
        MongoDBConnectionService mongoService = (MongoDBConnectionService)Framework.getService(MongoDBConnectionService.class);
        String connectionId = REPOSITORY_CONNECTION_PREFIX + descriptor.name;
        this.mongoClient = mongoService.getClient(connectionId);
        String dbname = mongoService.getDatabaseName(connectionId);
        MongoDatabase database = this.mongoClient.getDatabase(dbname);
        this.coll = database.getCollection(descriptor.name);
        this.countersColl = database.getCollection(descriptor.name + ".counters");
        this.settingsColl = database.getCollection(descriptor.name + ".settings");
        Duration maxTime = mongoService.getConfig((String)connectionId).maxTime;
        if (maxTime == null) {
            maxTime = MAX_TIME_DEFAULT;
        }
        this.maxTimeMS = maxTime.toMillis();
        this.idKey = Boolean.TRUE.equals(descriptor.nativeId) ? MONGODB_ID : COUNTER_NAME_UUID;
        boolean useCustomId = COUNTER_NAME_UUID.equals(this.idKey);
        if (this.idType == DBSRepositoryBase.IdType.sequence || this.idType == DBSRepositoryBase.IdType.sequenceHexRandomized) {
            Integer sbs = descriptor.sequenceBlockSize;
            this.sequenceBlockSize = sbs == null ? (this.idType == DBSRepositoryBase.IdType.sequenceHexRandomized ? 1000L : 1L) : sbs.longValue();
        }
        Set<String> idValuesKeys = this.idType == DBSRepositoryBase.IdType.sequenceHexRandomized ? DBSSession.ID_VALUES_KEYS : Set.of();
        this.converter = new MongoDBConverter(useCustomId ? null : COUNTER_NAME_UUID, DBSSession.TRUE_OR_NULL_BOOLEAN_KEYS, idValuesKeys);
        this.cursorService = new MongoDBCursorService(this.converter);
        try (ClientSession session = this.mongoClient.startSession();){
            hasSessions = true;
            try {
                session.startTransaction();
                session.abortTransaction();
                hasTransactions = true;
            }
            catch (MongoClientException e) {
                hasTransactions = false;
            }
        }
        catch (MongoClientException ee) {
            hasSessions = false;
            hasTransactions = false;
        }
        hasSessions = false;
        hasTransactions = false;
        this.supportsSessions = hasSessions;
        this.supportsTransactions = hasTransactions;
        this.initRepository();
    }

    public void shutdown() {
        super.shutdown();
        this.cursorService.clear();
    }

    protected void initRepository() {
        this.getConnection().close();
    }

    protected void initSettings() {
        this.supportsDenormalizedBlobKeys = true;
        Bson filter = Filters.eq((String)MONGODB_ID, (Object)SETTING_DENORMALIZED_BLOB_KEYS);
        Bson update = Updates.set((String)SETTING_VALUE, (Object)this.supportsDenormalizedBlobKeys);
        this.settingsColl.updateOne(filter, update, new UpdateOptions().upsert(true));
        this.initCapabilities();
    }

    protected void readSettings() {
        Document doc = (Document)this.settingsColl.find(Filters.eq((String)MONGODB_ID, (Object)SETTING_DENORMALIZED_BLOB_KEYS)).first();
        this.supportsDenormalizedBlobKeys = doc == null ? false : doc.getBoolean((Object)SETTING_VALUE, false);
        this.initCapabilities();
    }

    protected void initCapabilities() {
        this.capabilities.put("queryBlobKeys", this.supportsDenormalizedBlobKeys);
    }

    public MongoDBConnection getConnection() {
        return new MongoDBConnection(this);
    }

    public List<DBSRepositoryBase.IdType> getAllowedIdTypes() {
        return Arrays.asList(DBSRepositoryBase.IdType.varchar, DBSRepositoryBase.IdType.sequence, DBSRepositoryBase.IdType.sequenceHexRandomized);
    }

    protected boolean supportsSessions() {
        return this.supportsSessions;
    }

    public boolean supportsTransactions() {
        return this.supportsTransactions;
    }

    protected MongoClient getClient() {
        return this.mongoClient;
    }

    protected MongoDBCursorService getCursorService() {
        return this.cursorService;
    }

    protected MongoCollection<Document> getCollection() {
        return this.coll;
    }

    protected MongoCollection<Document> getCountersCollection() {
        return this.countersColl;
    }

    protected String getIdKey() {
        return this.idKey;
    }

    protected MongoDBConverter getConverter() {
        return this.converter;
    }

    protected void initBlobsPaths() {
        super.initBlobsPaths();
        ArrayList<Bson> projections = new ArrayList<Bson>(this.blobKeysPaths.size() + 1);
        projections.add(Projections.excludeId());
        this.blobKeysPaths.forEach(path -> projections.add(Projections.include((String[])new String[]{String.join((CharSequence)".", path)})));
        this.binaryKeys = Projections.fields(projections);
    }

    public void markReferencedBinaries() {
        Consumer<Document> markReferencedBinaries;
        Bson projection;
        Bson filter;
        DocumentBlobManager blobManager = (DocumentBlobManager)Framework.getService(DocumentBlobManager.class);
        if (this.supportsDenormalizedBlobKeys) {
            filter = Filters.exists((String)"ecm:blobKeys", (boolean)true);
            projection = Projections.fields((Bson[])new Bson[]{Projections.excludeId(), Projections.include((String[])new String[]{"ecm:blobKeys"})});
            markReferencedBinaries = doc -> this.markReferencedBinariesDenormalized((Document)doc, blobManager);
        } else {
            filter = new Document();
            projection = this.binaryKeys;
            markReferencedBinaries = doc -> this.markReferencedBinaries((Document)doc, blobManager);
        }
        log.trace("MongoDB: QUERY {} KEYS {}", (Object)filter, (Object)projection);
        this.coll.find(filter).projection(projection).forEach(markReferencedBinaries);
    }

    protected void markReferencedBinariesDenormalized(Document ob, DocumentBlobManager blobManager) {
        Object blobKeys = ob.get((Object)"ecm:blobKeys");
        if (blobKeys instanceof List) {
            for (Object v : (List)blobKeys) {
                if (!(v instanceof String)) continue;
                blobManager.markReferencedBinary((String)v, this.repositoryName);
            }
        }
    }

    protected void markReferencedBinaries(Document ob, DocumentBlobManager blobManager) {
        for (Object value : ob.values()) {
            if (value instanceof List) {
                List list = (List)value;
                for (Object v : list) {
                    if (v instanceof Document) {
                        this.markReferencedBinaries((Document)v, blobManager);
                        continue;
                    }
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    this.markReferencedBinary(v, blobManager);
                }
                continue;
            }
            if (value instanceof Document) {
                this.markReferencedBinaries((Document)value, blobManager);
                continue;
            }
            this.markReferencedBinary(value, blobManager);
        }
    }

    protected void markReferencedBinary(Object value, DocumentBlobManager blobManager) {
        if (!(value instanceof String)) {
            return;
        }
        String key = (String)value;
        blobManager.markReferencedBinary(key, this.repositoryName);
    }
}

