/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;

@Operation(id="Elasticsearch.BulkIndex", category="Services", label="Elasticsearch Indexing", since="10.3", description="Enable to index Nuxeo documents using the Bulk Service.", addToStudio=false)
public class ElasticsearchBulkIndexOperation {
    private static final Log log = LogFactory.getLog(ElasticsearchBulkIndexOperation.class);
    public static final String ID = "Elasticsearch.BulkIndex";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected ElasticSearchAdmin esa;
    @Context
    protected BulkService bulkService;

    @OperationMethod
    public Blob run() throws IOException {
        this.checkAccess();
        this.esa.dropAndInitRepositoryIndex(this.session.getRepositoryName(), false);
        String commandId = this.submitBulkCommand("SELECT ecm:uuid FROM Document", true);
        log.warn((Object)String.format("Submitted index command: %s to index the entire %s repository.", commandId, this.session.getRepositoryName()));
        return Blobs.createJSONBlobFromValue(Collections.singletonMap("commandId", commandId));
    }

    protected String submitBulkCommand(String nxql, boolean syncAlias) {
        String username = this.session.getPrincipal().getName();
        String repository = this.session.getRepositoryName();
        return this.bulkService.submit(new BulkCommand.Builder("index", nxql, username).repository(repository).param("updateAlias", (Serializable)Boolean.valueOf(syncAlias)).build());
    }

    protected void checkAccess() {
        NuxeoPrincipal principal = this.ctx.getPrincipal();
        if (principal == null || !principal.isAdministrator()) {
            throw new NuxeoException("Unauthorized access: " + principal);
        }
    }

    @OperationMethod
    public Blob run(String nxql) throws IOException {
        this.checkAccess();
        String commandId = this.submitBulkCommand(nxql, false);
        return Blobs.createJSONBlobFromValue(Collections.singletonMap("commandId", commandId));
    }
}

