/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.forms.validation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.forms.FormDataProvider;
import org.nuxeo.ecm.webengine.forms.validation.Form;
import org.nuxeo.ecm.webengine.forms.validation.FormDescriptor;
import org.nuxeo.ecm.webengine.forms.validation.ValidationException;
import org.nuxeo.runtime.api.Framework;

public class FormManager
implements InvocationHandler,
Form {
    protected Map<String, Object> map;
    protected Map<String, String[]> fields;
    protected List<String> unknownKeys;
    protected FormDescriptor fd;
    protected static Map<Class<?>, FormDescriptor> forms = new ConcurrentHashMap();

    public FormManager(FormDescriptor fd) {
        this.fd = fd;
        this.unknownKeys = new ArrayList<String>();
        this.map = new HashMap<String, Object>();
        this.fields = new HashMap<String, String[]>();
    }

    @Override
    public Collection<String> unknownKeys() {
        return this.unknownKeys;
    }

    @Override
    public Map<String, String[]> fields() {
        return this.fields;
    }

    @Override
    public void load(FormDataProvider data, Form proxy) throws ValidationException {
        ValidationException ve = null;
        Set reqs = (Set)this.fd.requiredFields.clone();
        for (String key : data.getKeys()) {
            FormDescriptor.Field f;
            String[] values = data.getList(key);
            if (values != null) {
                int k = 0;
                for (String v : values) {
                    if (v.length() != 0) continue;
                    ++k;
                }
                if (k == values.length) {
                    values = null;
                }
            }
            if (values != null) {
                this.fields.put(key, values);
                reqs.remove(key);
            }
            if ((f = this.fd.fields.get(key)) != null) {
                Object o = null;
                try {
                    if (f.isArray) {
                        if (values != null) {
                            o = f.validateArray(values);
                        }
                    } else {
                        String v;
                        String string = v = values != null && values.length > 0 ? values[0] : null;
                        if (v != null && v.length() > 0) {
                            o = f.validate(v);
                        }
                    }
                }
                catch (ValidationException e) {
                    if (ve == null) {
                        ve = e;
                    }
                    ve.addInvalidField(key);
                }
                this.map.put(key, o);
                continue;
            }
            this.unknownKeys.add(key);
        }
        if (!reqs.isEmpty()) {
            if (ve == null) {
                ve = new ValidationException();
            }
            for (String req : reqs) {
                ve.addRequiredField(req);
            }
        }
        if (ve != null) {
            throw ve;
        }
        if (this.fd.validator != null) {
            this.fd.validator.validate(data, proxy);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Form.class) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        String name = method.getName();
        int len = name.length();
        if (len > 3 && name.startsWith("get")) {
            name = FormDescriptor.getFieldName(name, len);
            return this.map.get(name);
        }
        throw new UnsupportedOperationException("Method unsupported: " + method);
    }

    public static <T> T newProxy(Class<T> type) {
        WebEngine we = (WebEngine)Framework.getService(WebEngine.class);
        ClassLoader cl = we != null ? we.getWebLoader().getClassLoader() : FormManager.class.getClassLoader();
        return (T)Proxy.newProxyInstance(cl, new Class[]{type}, (InvocationHandler)new FormManager(FormManager.getDescriptor(type)));
    }

    public void flushCache() {
        forms.clear();
    }

    static FormDescriptor getDescriptor(Class<?> type) {
        FormDescriptor fd = forms.get(type);
        if (fd == null) {
            try {
                fd = new FormDescriptor(type);
                forms.put(type, fd);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to build form descriptor", e);
            }
        }
        return fd;
    }
}

