/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.contribution.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.contribution.Contribution;
import org.nuxeo.runtime.contribution.ContributionRegistry;
import org.nuxeo.runtime.contribution.impl.AbstractContributionRegistry;

public class ContributionImpl<K, T>
implements Contribution<K, T> {
    private static final Log log = LogFactory.getLog(ContributionImpl.class);
    protected final AbstractContributionRegistry<K, T> registry;
    protected final K primaryKey;
    protected final List<T> mainFragments = new ArrayList<T>();
    protected final List<T> fragments = new ArrayList<T>();
    protected final Set<Contribution<K, T>> dependencies = new HashSet<Contribution<K, T>>();
    protected final Set<Contribution<K, T>> dependents = new HashSet<Contribution<K, T>>();
    protected T value;
    protected boolean isResolved = false;

    public ContributionImpl(AbstractContributionRegistry<K, T> reg, K primaryKey) {
        this.primaryKey = primaryKey;
        this.registry = reg;
    }

    @Override
    public ContributionRegistry<K, T> getRegistry() {
        return this.registry;
    }

    @Override
    public K getId() {
        return this.primaryKey;
    }

    @Override
    public Iterator<T> iterator() {
        return this.fragments.iterator();
    }

    @Override
    public Set<Contribution<K, T>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<Contribution<K, T>> getDependents() {
        return this.dependents;
    }

    @Override
    public Set<Contribution<K, T>> getUnresolvedDependencies() {
        HashSet<Contribution<K, T>> set = new HashSet<Contribution<K, T>>();
        for (Contribution<K, T> dep : this.dependencies) {
            if (!dep.isResolved()) continue;
            set.add(dep);
        }
        return set;
    }

    protected boolean checkIsResolved() {
        if (this.mainFragments.isEmpty()) {
            return false;
        }
        for (Contribution<K, T> dep : this.dependencies) {
            if (dep.isResolved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.fragments.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    @Override
    public T getFragment(int index) {
        return this.fragments.get(index);
    }

    @Override
    public boolean removeFragment(Object fragment) {
        if (this.mainFragments.remove(fragment)) {
            if (this.mainFragments.isEmpty()) {
                if (this.fragments.isEmpty()) {
                    this.unregister();
                } else {
                    this.unresolve();
                }
            } else {
                this.update();
            }
            return true;
        }
        if (this.fragments.remove(fragment)) {
            if (!this.mainFragments.isEmpty()) {
                this.update();
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addFragment(T fragment, K ... superKeys) {
        if (this.registry.isMainFragment(fragment)) {
            this.mainFragments.add(fragment);
        } else {
            this.fragments.add(fragment);
        }
        if (superKeys != null && superKeys.length > 0 && superKeys[0] != null) {
            for (K superKey : superKeys) {
                Contribution<K, T> c = this.registry.getOrCreateDependency(superKey);
                this.dependencies.add(c);
                c.getDependents().add(this);
            }
        }
        this.update();
    }

    @Override
    public T getValue() {
        if (!this.isResolved) {
            throw new IllegalStateException("Cannot compute merged values for not resolved contributions");
        }
        if (this.mainFragments.isEmpty() || this.value != null) {
            return this.value;
        }
        T result = this.registry.clone(this.mainFragments.get(this.mainFragments.size() - 1));
        for (Contribution<K, T> key : this.dependencies) {
            T superObject = this.registry.getContribution(key.getId()).getValue();
            this.registry.applySuperFragment(result, superObject);
        }
        for (Contribution<K, T> fragment : this) {
            this.registry.applyFragment((Contribution<K, T>)result, fragment);
        }
        this.value = result;
        return result;
    }

    @Override
    public boolean isPhantom() {
        return this.mainFragments.isEmpty();
    }

    @Override
    public boolean isResolved() {
        return this.isResolved;
    }

    @Override
    public boolean isRegistered() {
        return !this.fragments.isEmpty();
    }

    protected void update() {
        T oldValue = this.value;
        this.value = null;
        boolean canResolve = this.checkIsResolved();
        if (this.isResolved != canResolve) {
            if (canResolve) {
                this.resolve();
            } else {
                this.unresolve();
            }
        } else if (this.isResolved) {
            this.registry.fireUpdated(oldValue, this);
        }
    }

    @Override
    public void unregister() {
        if (this.isResolved) {
            this.unresolve();
        }
        this.fragments.clear();
        this.value = null;
    }

    @Override
    public void unresolve() {
        if (!this.isResolved) {
            return;
        }
        this.isResolved = false;
        for (Contribution<K, T> dep : this.dependents) {
            dep.unresolve();
        }
        this.registry.fireUnresolved(this, this.value);
        this.value = null;
    }

    @Override
    public void resolve() {
        if (this.isResolved || this.isPhantom()) {
            throw new IllegalStateException("Cannot resolve. Invalid state. phantom: " + this.isPhantom() + "; resolved: " + this.isResolved);
        }
        if (this.checkIsResolved()) {
            this.isResolved = true;
            this.registry.fireResolved(this);
            for (Contribution<K, T> dep : this.dependents) {
                if (dep.isResolved()) continue;
                dep.resolve();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ContributionImpl) {
            ContributionImpl other = (ContributionImpl)obj;
            return this.primaryKey.equals(other.primaryKey);
        }
        return false;
    }

    public String toString() {
        return this.primaryKey.toString() + " [ phantom: " + this.isPhantom() + "; resolved: " + this.isResolved + "]";
    }
}

