/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.io;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentRouteWriter
extends ExtensibleEntityJsonWriter<DocumentRoute> {
    public static final String ATTACHED_DOCUMENT_IDS = "attachedDocumentIds";
    public static final String FETCH_ATTACHED_DOCUMENTS = "attachedDocumentIds";
    public static final String ENTITY_TYPE = "workflow";
    public static final String FETCH_INITATIOR = "initiator";
    @Inject
    UserManager userManager;
    @Inject
    private SchemaManager schemaManager;

    public DocumentRouteWriter() {
        super(ENTITY_TYPE, DocumentRoute.class);
    }

    protected void writeEntityBody(DocumentRoute item, JsonGenerator jg) throws IOException {
        jg.writeStringField("id", item.getDocument().getId());
        jg.writeStringField("name", item.getName());
        jg.writeStringField("title", item.getTitle());
        jg.writeStringField("state", item.getDocument().getCurrentLifeCycleState());
        jg.writeStringField("workflowModelName", item.getModelName());
        if (this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_INITATIOR)) {
            NuxeoPrincipal principal = this.userManager.getPrincipal(item.getInitiator());
            if (principal != null) {
                this.writeEntityField(FETCH_INITATIOR, principal, jg);
            } else {
                jg.writeStringField(FETCH_INITATIOR, item.getInitiator());
            }
        } else {
            jg.writeStringField(FETCH_INITATIOR, item.getInitiator());
        }
        jg.writeArrayFieldStart("attachedDocumentIds");
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(item.getDocument());){
            boolean isFetchAttachedDocumentIds = this.ctx.getFetched(ENTITY_TYPE).contains("attachedDocumentIds");
            for (String docId : item.getAttachedDocuments()) {
                if (isFetchAttachedDocumentIds) {
                    IdRef idRef = new IdRef(docId);
                    if (wrapper.getSession().exists((DocumentRef)idRef)) {
                        this.writeEntity(wrapper.getSession().getDocument((DocumentRef)idRef), jg);
                        break;
                    }
                }
                jg.writeStartObject();
                jg.writeStringField("id", docId);
                jg.writeEndObject();
            }
        }
        jg.writeEndArray();
        if (item instanceof GraphRoute) {
            jg.writeFieldName("variables");
            jg.writeStartObject();
            DocumentRouteWriter.writeVariables(item, jg, this.registry, this.ctx, this.schemaManager);
            jg.writeEndObject();
            String graphResourceUrl = DocumentRouteWriter.getGraphResourceURL(item, this.ctx);
            jg.writeStringField("graphResource", graphResourceUrl);
        }
    }

    public static void writeVariables(DocumentRoute item, JsonGenerator jg, MarshallerRegistry registry, RenderingContext ctx, SchemaManager schemaManager) throws IOException, JsonGenerationException {
        CompositeType type;
        String facet = (String)((Object)item.getDocument().getPropertyValue("docri:variablesFacet"));
        if (StringUtils.isNotBlank((CharSequence)facet) && (type = schemaManager.getFacet(facet)) != null) {
            boolean hasFacet = item.getDocument().hasFacet(facet);
            Writer propertyWriter = registry.getWriter(ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
            try (Closeable resource = ctx.wrap().with("document", (Object)item.getDocument()).open();){
                for (Field f : type.getFields()) {
                    String name = f.getName().getLocalName();
                    Property property = hasFacet ? item.getDocument().getProperty(name) : null;
                    OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                    jg.writeFieldName(name);
                    propertyWriter.write((Object)property, Property.class, Property.class, MediaType.APPLICATION_JSON_TYPE, (OutputStream)out);
                }
            }
        }
    }

    public static String getGraphResourceURL(DocumentRoute route, RenderingContext ctx) {
        StringBuilder sb = new StringBuilder(ctx.getBaseUrl());
        sb.append("api/v1/");
        if (route.isValidated()) {
            sb.append("workflowModel/").append(route.getDocument().getName());
        } else {
            sb.append("workflow/").append(route.getDocument().getId());
        }
        sb.append("/graph");
        return sb.toString();
    }
}

