/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.listener;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class DocumentRouteOrphanedListener
implements PostCommitEventListener {
    protected static final String QUERY_GET_RELATED_DOCUMENT_ROUTES = "SELECT * FROM DocumentRoute WHERE docri:participatingDocuments = '%s'";

    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            DocumentEventContext context = (DocumentEventContext)event.getContext();
            DocumentModel docModel = context.getSourceDocument();
            if ("DocumentRoute".equals(docModel.getType()) || "RoutingTask".equals(docModel.getType())) continue;
            this.deleteOrphanDocumentRoutes(context.getCoreSession(), docModel.getId());
        }
    }

    protected void deleteOrphanDocumentRoutes(CoreSession session, String id) {
        String query = String.format(QUERY_GET_RELATED_DOCUMENT_ROUTES, id);
        for (DocumentModel doc : session.query(query)) {
            List attachedDocuments = (List)((Object)doc.getPropertyValue("docri:participatingDocuments"));
            attachedDocuments.remove(id);
            if (attachedDocuments.isEmpty()) {
                session.removeDocument(doc.getRef());
                continue;
            }
            doc.setPropertyValue("docri:participatingDocuments", (Serializable)((Object)attachedDocuments));
            session.saveDocument(doc);
        }
    }
}

