/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.providers;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuth2ServiceProviderRegistryImpl
extends DefaultComponent
implements OAuth2ServiceProviderRegistry {
    private static final Logger log = LogManager.getLogger(OAuth2ServiceProviderRegistryImpl.class);
    public static final String PROVIDER_EP = "providers";
    public static final String DIRECTORY_NAME = "oauth2ServiceProviders";
    public static final String SCHEMA = "oauth2ServiceProvider";
    protected static final String SERVICE_NAME_KEY = "serviceName";

    public void start(ComponentContext context) {
        this.persistProviders();
    }

    protected DocumentModel getPersistedProvider(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            log.warn("Cannot fetch provider without a serviceName");
            return null;
        }
        List<DocumentModel> providers = this.queryProviders(Map.of(SERVICE_NAME_KEY, serviceName), 1);
        return providers.isEmpty() ? null : providers.get(0);
    }

    protected void persistProviders() {
        this.getRegistryContributions(PROVIDER_EP).forEach(desc -> {
            String name = desc.getName();
            if (this.getPersistedProvider(name) == null) {
                this.addProvider(name, desc.getDescription(), desc.getTokenServerURL(), desc.getAuthorizationServerURL(), desc.getClientId(), desc.getClientSecret(), Arrays.asList(desc.getScopes()));
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = desc::getName;
                log.info("Provider {} is already in the Database, XML contribution  won't overwrite it", supplierArray);
            }
        });
    }

    @Override
    public OAuth2ServiceProvider getProvider(String serviceName) {
        return this.buildProvider(this.getPersistedProvider(serviceName));
    }

    @Override
    public List<OAuth2ServiceProvider> getProviders() {
        List<DocumentModel> providers = this.queryProviders(Collections.emptyMap(), 0);
        return providers.stream().map(this::buildProvider).collect(Collectors.toList());
    }

    @Override
    public OAuth2ServiceProvider addProvider(String serviceName, String description, String tokenServerURL, String authorizationServerURL, String clientId, String clientSecret, List<String> scopes) {
        return this.addProvider(serviceName, description, tokenServerURL, authorizationServerURL, null, clientId, clientSecret, scopes, Boolean.TRUE);
    }

    protected void fillEntryProperties(DocumentModel entry, String serviceName, String description, String tokenServerURL, String authorizationServerURL, String userAuthorizationURL, String clientId, String clientSecret, List<String> scopes, Boolean isEnabled) {
        entry.setProperty(SCHEMA, SERVICE_NAME_KEY, (Object)serviceName);
        entry.setProperty(SCHEMA, "description", (Object)description);
        entry.setProperty(SCHEMA, "authorizationServerURL", (Object)authorizationServerURL);
        entry.setProperty(SCHEMA, "tokenServerURL", (Object)tokenServerURL);
        entry.setProperty(SCHEMA, "userAuthorizationURL", (Object)userAuthorizationURL);
        entry.setProperty(SCHEMA, "clientId", (Object)clientId);
        entry.setProperty(SCHEMA, "clientSecret", (Object)clientSecret);
        entry.setProperty(SCHEMA, "scopes", (Object)String.join((CharSequence)",", scopes));
        boolean enabled = clientId != null && clientSecret != null;
        entry.setProperty(SCHEMA, "enabled", (Object)(enabled && Boolean.TRUE.equals(isEnabled) ? 1 : 0));
        if (!enabled) {
            log.info("OAuth2 provider for {} is disabled because clientId and/or clientSecret are empty", (Object)serviceName);
        }
    }

    protected void fillProviderProperties(OAuth2ServiceProvider provider, DocumentModel entry) {
        provider.setId((Long)entry.getProperty(SCHEMA, "id"));
        provider.setDescription((String)entry.getProperty(SCHEMA, "description"));
        provider.setAuthorizationServerURL((String)entry.getProperty(SCHEMA, "authorizationServerURL"));
        provider.setTokenServerURL((String)entry.getProperty(SCHEMA, "tokenServerURL"));
        provider.setUserAuthorizationURL((String)entry.getProperty(SCHEMA, "userAuthorizationURL"));
        provider.setClientId((String)entry.getProperty(SCHEMA, "clientId"));
        provider.setClientSecret((String)entry.getProperty(SCHEMA, "clientSecret"));
        String scopes = (String)entry.getProperty(SCHEMA, "scopes");
        provider.setScopes(StringUtils.split((String)scopes, (String)","));
        provider.setEnabled((Boolean)entry.getProperty(SCHEMA, "enabled"));
    }

    @Override
    public OAuth2ServiceProvider addProvider(String serviceName, String description, String tokenServerURL, String authorizationServerURL, String userAuthorizationURL, String clientId, String clientSecret, List<String> scopes, Boolean isEnabled) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel creationEntry = BaseSession.createEntryModel((String)SCHEMA, null, null);
            DocumentModel entry = (DocumentModel)Framework.doPrivileged(() -> session.createEntry(creationEntry));
            this.fillEntryProperties(entry, serviceName, description, tokenServerURL, authorizationServerURL, userAuthorizationURL, clientId, clientSecret, scopes, isEnabled);
            Framework.doPrivileged(() -> session.updateEntry(entry));
            OAuth2ServiceProvider oAuth2ServiceProvider = this.getProvider(serviceName);
            return oAuth2ServiceProvider;
        }
    }

    @Override
    public OAuth2ServiceProvider updateProvider(String serviceName, OAuth2ServiceProvider provider) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel entry = this.getPersistedProvider(serviceName);
            this.fillEntryProperties(entry, serviceName, provider.getDescription(), provider.getTokenServerURL(), provider.getAuthorizationServerURL(), provider.getUserAuthorizationURL(), provider.getClientId(), provider.getClientSecret(), provider.getScopes(), provider.isEnabled());
            session.updateEntry(entry);
            OAuth2ServiceProvider oAuth2ServiceProvider = this.getProvider(serviceName);
            return oAuth2ServiceProvider;
        }
    }

    @Override
    public void deleteProvider(String serviceName) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(DIRECTORY_NAME);){
            DocumentModel entry = this.getPersistedProvider(serviceName);
            session.deleteEntry(entry);
        }
    }

    protected List<DocumentModel> queryProviders(Map<String, Serializable> filter, int limit) {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        return (List)Framework.doPrivileged(() -> {
            DocumentModelList documentModelList;
            block8: {
                Session session = ds.open(DIRECTORY_NAME);
                try {
                    Set fulltext = Collections.emptySet();
                    Map orderBy = Collections.emptyMap();
                    documentModelList = session.query(filter, fulltext, orderBy, true, limit, 0);
                    if (session == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DirectoryException e) {
                        log.error("Error while fetching provider directory", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                session.close();
            }
            return documentModelList;
        });
    }

    protected OAuth2ServiceProvider buildProvider(DocumentModel entry) {
        if (entry == null) {
            return null;
        }
        String serviceName = (String)entry.getProperty(SCHEMA, SERVICE_NAME_KEY);
        OAuth2ServiceProvider provider = this.createProviderInstance(serviceName);
        if (provider == null) {
            provider = new NuxeoOAuth2ServiceProvider();
            provider.setServiceName(serviceName);
        }
        this.fillProviderProperties(provider, entry);
        return provider;
    }

    protected OAuth2ServiceProvider createProviderInstance(String name) {
        return this.getRegistryContribution(PROVIDER_EP, name).map(desc -> {
            OAuth2ServiceProvider provider = null;
            try {
                Class<? extends OAuth2ServiceProvider> providerClass = desc.getProviderClass();
                provider = providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                provider.setDescription(desc.getDescription());
                provider.setAuthorizationServerURL(desc.getAuthorizationServerURL());
                provider.setTokenServerURL(desc.getTokenServerURL());
                provider.setServiceName(desc.getName());
                provider.setClientId(desc.getClientId());
                provider.setClientSecret(desc.getClientSecret());
                provider.setScopes(desc.getScopes());
                provider.setEnabled(true);
            }
            catch (Exception e) {
                log.error("Failed to instantiate UserResolver", (Throwable)e);
            }
            return provider;
        }).orElse(null);
    }
}

