/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnectDecoder;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.Referral;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulDisconnect
extends ExtendedResponseImpl {
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.5";
    private static final Logger log = LoggerFactory.getLogger(GracefulDisconnect.class);
    private int timeOffline;
    private int delay;
    private Referral replicatedContexts = new ReferralImpl();

    public GracefulDisconnect(byte[] value) throws DecoderException {
        super(0, EXTENSION_OID);
        this.value = value;
        this.decodeValue();
    }

    public GracefulDisconnect(int timeOffline, int delay) {
        super(0, EXTENSION_OID);
        this.oid = EXTENSION_OID;
        this.timeOffline = timeOffline;
        this.delay = delay;
        StringBuffer buf = new StringBuffer();
        buf.append("The server will disconnect and will be unavailable for ").append(timeOffline);
        buf.append(" minutes in ").append(delay).append(" seconds.");
        super.getLdapResult().setErrorMessage(buf.toString());
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.UNAVAILABLE);
        this.encodeResponse();
    }

    private void decodeValue() throws DecoderException {
        GracefulDisconnectDecoder decoder = new GracefulDisconnectDecoder();
        org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect codec = null;
        try {
            codec = (org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect)decoder.decode(this.value);
            this.timeOffline = codec.getTimeOffline();
            this.delay = codec.getDelay();
            super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
            List<LdapURL> contexts = codec.getReplicatedContexts();
            for (int ii = 0; ii < contexts.size(); ++ii) {
                this.replicatedContexts.addLdapUrl(((Object)contexts.get(ii)).toString());
            }
        }
        catch (DecoderException e) {
            log.error("Failed to decode response value", (Throwable)e);
            throw e;
        }
    }

    private void encodeResponse() {
        org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect codec = new org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect();
        codec.setTimeOffline(this.timeOffline);
        codec.setDelay(this.delay);
        for (String urlstr : this.replicatedContexts.getLdapUrls()) {
            LdapURL url = null;
            try {
                url = new LdapURL(urlstr);
            }
            catch (LdapURLEncodingException e) {
                log.error("Failed while parsing LDAP url " + urlstr, (Throwable)e);
                continue;
            }
            codec.addReplicatedContexts(url);
        }
        try {
            this.value = codec.encode(null).array();
        }
        catch (EncoderException e) {
            log.error("Failed to encode message value.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public byte[] getResponse() {
        if (this.value == null) {
            this.encodeResponse();
        }
        return this.value;
    }

    public void setResponse(byte[] value) {
        ByteBuffer bb = ByteBuffer.wrap(value);
        GracefulDisconnectContainer container = new GracefulDisconnectContainer();
        Asn1Decoder decoder = new Asn1Decoder();
        try {
            decoder.decode(bb, (IAsn1Container)container);
        }
        catch (DecoderException e) {
            log.error("Failed while decoding response", (Throwable)e);
        }
        org.apache.directory.shared.ldap.codec.extended.operations.GracefulDisconnect codec = container.getGracefulDisconnect();
        this.delay = codec.getDelay();
        this.timeOffline = codec.getTimeOffline();
        List<LdapURL> contexts = codec.getReplicatedContexts();
        for (int ii = 0; ii < contexts.size(); ++ii) {
            LdapURL url = contexts.get(ii);
            this.replicatedContexts.addLdapUrl(url.toString());
        }
        this.value = value;
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException("the OID is fixed: 1.3.6.1.4.1.18060.0.1.5");
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setTimeOffline(int timeOffline) {
        this.timeOffline = timeOffline;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getTimeOffline() {
        return this.timeOffline;
    }

    public Referral getReplicatedContexts() {
        return this.replicatedContexts;
    }
}

