/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audio.extension;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class AudioImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AudioImporter.class);
    public static final String AUDIO_TYPE = "Audio";

    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        CoreSession session = context.getSession();
        Blob blob = context.getBlob();
        String filename = FileManagerUtils.fetchFileName((String)context.getFileName());
        blob.setFilename(filename);
        String title = FileManagerUtils.fetchTitle((String)filename);
        String parentPath = context.getParentPath();
        DocumentModel docModel = FileManagerUtils.getExistingDocByTitle((CoreSession)session, (String)parentPath, (String)title);
        if (context.isOverwrite() && docModel != null) {
            docModel.setPropertyValue("file:content", (Serializable)blob);
            docModel.setPropertyValue("dc:title", (Serializable)((Object)title));
            this.checkIn(docModel);
            docModel = session.saveDocument(docModel);
        } else {
            PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            String docType = this.getDocType();
            if (docType == null) {
                docType = AUDIO_TYPE;
            }
            docModel = session.createDocumentModel(docType);
            docModel.setPropertyValue("file:content", (Serializable)blob);
            docModel.setPropertyValue("dc:title", (Serializable)((Object)title));
            Type type = ((TypeManager)Framework.getService(TypeManager.class)).getType(docType);
            if (type != null) {
                String iconPath = type.getIcon();
                docModel.setProperty("common", "icon", (Object)iconPath);
            }
            docModel.setPathInfo(parentPath, pss.generatePathSegment(docModel));
            docModel = session.createDocument(docModel);
        }
        return docModel;
    }
}

