/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.invite;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.user.invite.InvitationUserFactory;

@XObject(value="configuration")
@XRegistry(compatWarnOnMerge=true)
public class UserRegistrationConfiguration {
    private static Log log = LogFactory.getLog(UserRegistrationConfiguration.class);
    public static final String DEFAULT_CONFIGURATION_NAME = "default_registration";
    @XNode(value="@name", defaultAssignment="default_registration")
    @XRegistryId
    private String name;
    @XNode(value="requestDocType")
    private String requestDocType;
    @XNode(value="userInfo/schemaName")
    private String userInfoSchemaName = "userinfo";
    @XNode(value="userInfo/usernameField")
    private String userInfoUsernameField = "userinfo:login";
    @XNode(value="userInfo/emailField")
    private String userInfoEmailField = "userinfo:email";
    @XNode(value="userInfo/firstnameField")
    private String userInfoFirstnameField = "userinfo:firstName";
    @XNode(value="userInfo/lastnameField")
    private String userInfoLastnameField = "userinfo:lastName";
    @XNode(value="userInfo/companyField")
    private String userInfoCompanyField = "userinfo:company";
    @Deprecated(since="7.3")
    @XNode(value="userInfo/passwordField")
    private String userInfoPasswordField = "userinfo:password";
    @XNode(value="userInfo/groupsField")
    private String userInfoGroupsField = "userinfo:groups";
    @XNode(value="userInfo/tenantIdField")
    private String userInfoTenantIdField = "userinfo:tenantId";
    @XNode(value="container/docType")
    private String containerDocType;
    @XNode(value="container/parentPath")
    private String containerParentPath;
    @XNode(value="container/name")
    private String containerName;
    @XNode(value="container/title")
    private String containerTitle;
    @XNode(value="validationEmail/title")
    private String validationEmailTitle;
    @XNode(value="validationEmail/template")
    private String validationEmailTemplate;
    @XNode(value="successEmail/title")
    private String successEmailTitle;
    @XNode(value="successEmail/template")
    private String successEmailTemplate;
    @XNode(value="reviveEmail/title")
    private String reviveEmailTitle;
    @XNode(value="reviveEmail/template")
    private String reviveEmailTemplate;
    @XNode(value="registrationUserFactory")
    private Class<? extends InvitationUserFactory> registrationUserFactory;
    @XNode(value="validationRelUrl")
    private String validationRelUrl;
    @XNode(value="enterPasswordUrl")
    private String enterPasswordUrl;
    @XNode(value="invitationLayout")
    private String invitationLayout = "user_invitation_info";
    @XNode(value="listingContentView")
    private String listingLocalContentView = "local_user_requests_view";

    public String getRequestDocType() {
        return this.requestDocType;
    }

    public String getContainerDocType() {
        return this.containerDocType;
    }

    public String getContainerParentPath() {
        return this.containerParentPath;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerTitle() {
        return this.containerTitle;
    }

    public String getValidationEmailTitle() {
        return this.validationEmailTitle;
    }

    public String getValidationEmailTemplate() {
        return this.validationEmailTemplate;
    }

    public String getSuccessEmailTitle() {
        return this.successEmailTitle;
    }

    public String getSuccessEmailTemplate() {
        return this.successEmailTemplate;
    }

    public Class<? extends InvitationUserFactory> getRegistrationUserFactory() {
        return this.registrationUserFactory;
    }

    public String getValidationRelUrl() {
        if (StringUtils.isBlank((CharSequence)this.validationRelUrl)) {
            log.info((Object)("Configuration " + this.name + " has empty validation url"));
            return "";
        }
        return this.validationRelUrl;
    }

    public String getEnterPasswordUrl() {
        if (StringUtils.isBlank((CharSequence)this.enterPasswordUrl)) {
            log.info((Object)("Configuration " + this.name + " has empty validation url"));
            return "";
        }
        if (this.enterPasswordUrl.startsWith("/")) {
            this.enterPasswordUrl = this.enterPasswordUrl.substring(1);
        }
        return this.enterPasswordUrl;
    }

    public String getReviveEmailTitle() {
        return this.reviveEmailTitle;
    }

    public String getReviveEmailTemplate() {
        return this.reviveEmailTemplate;
    }

    public String getUserInfoSchemaName() {
        return this.userInfoSchemaName;
    }

    public String getUserInfoUsernameField() {
        return this.userInfoUsernameField;
    }

    public String getUserInfoEmailField() {
        return this.userInfoEmailField;
    }

    public String getUserInfoFirstnameField() {
        return this.userInfoFirstnameField;
    }

    public String getUserInfoLastnameField() {
        return this.userInfoLastnameField;
    }

    public String getUserInfoCompanyField() {
        return this.userInfoCompanyField;
    }

    @Deprecated(since="7.3")
    public String getUserInfoPasswordField() {
        return this.userInfoPasswordField;
    }

    public String getUserInfoGroupsField() {
        return this.userInfoGroupsField;
    }

    public String getUserInfoTenantIdField() {
        return this.userInfoTenantIdField;
    }

    public String getName() {
        return this.name;
    }

    public String getInvitationLayout() {
        return this.invitationLayout;
    }

    public String getListingLocalContentView() {
        return this.listingLocalContentView;
    }
}

