/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Calendar;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.tokenauth.io.AuthenticationToken;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class AuthenticationTokenWriter
extends AbstractJsonWriter<AuthenticationToken> {
    public static final String ENTITY_TYPE = "token";

    public void write(AuthenticationToken token, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", ENTITY_TYPE);
        jg.writeStringField("id", token.getToken());
        jg.writeStringField("username", token.getUserName());
        jg.writeStringField("application", token.getApplicationName());
        jg.writeStringField("deviceId", token.getDeviceId());
        jg.writeStringField("deviceDescription", token.getDeviceDescription());
        jg.writeStringField("permission", token.getPermission());
        jg.writeStringField("creationDate", DateUtils.formatISODateTime((Calendar)DateUtils.nowIfNull((Calendar)token.getCreationDate())));
        jg.writeEndObject();
    }
}

