/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.web.resources.core.ResourceDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.theme.styling.negotiation.Negotiator;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.IconDescriptor;
import org.nuxeo.theme.styling.service.descriptors.LogoDescriptor;
import org.nuxeo.theme.styling.service.descriptors.NegotiatorDescriptor;
import org.nuxeo.theme.styling.service.descriptors.PageDescriptor;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;
import org.nuxeo.theme.styling.service.descriptors.SimpleStyle;
import org.nuxeo.theme.styling.service.palettes.PaletteParseException;
import org.nuxeo.theme.styling.service.palettes.PaletteParser;
import org.nuxeo.theme.styling.service.registries.PageRegistry;

public class ThemeStylingServiceImpl
extends DefaultComponent
implements ThemeStylingService {
    private static final Logger log = LogManager.getLogger(ThemeStylingServiceImpl.class);
    protected static final String WR_EX = "org.nuxeo.ecm.platform.WebResources";
    protected static final String PAGE_EP = "pages";
    protected static final String FLAVOR_EP = "flavors";
    protected static final String NEGO_EP = "negotiations";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (contribution instanceof SimpleStyle) {
            SimpleStyle style = (SimpleStyle)contribution;
            ComponentName compName = contributor.getName();
            String message = String.format("Style '%s' on component %s should now be contributed to extension point '%s'. Note that the 'flavor' processor should be used with this resource.", style.getName(), compName, WR_EX);
            DeprecationLogger.log((String)message, (String)"7.4");
            this.addRuntimeMessage(RuntimeMessage.Level.ERROR, message, RuntimeMessage.Source.EXTENSION, compName.getName());
        } else if (contribution instanceof ResourceDescriptor) {
            ResourceDescriptor resource = (ResourceDescriptor)contribution;
            ComponentName compName = contributor.getName();
            String message = String.format("Resource '%s' on component %s should now be contributed to extension point '%s'.", resource.getName(), compName, WR_EX);
            DeprecationLogger.log((String)message, (String)"7.4");
            this.addRuntimeMessage(RuntimeMessage.Level.ERROR, message, RuntimeMessage.Source.EXTENSION, compName.getName());
        } else {
            log.error("Unknown contribution to the theme styling service, extension point '{}': '{}'", (Object)extensionPoint, contribution);
        }
    }

    protected List<FlavorPresets> computePresets(FlavorDescriptor flavor, List<String> flavors) {
        ArrayList<FlavorPresets> presets = new ArrayList<FlavorPresets>();
        if (flavor != null) {
            String extendsFlavorName;
            List<FlavorPresets> localPresets = flavor.getPresets();
            if (localPresets != null) {
                presets.addAll(localPresets);
            }
            if (!StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = flavor::getName;
                    log.error("Cyclic dependency detected in flavor '{}' hierarchy", supplierArray);
                    return presets;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    List<FlavorPresets> parentPresets = this.computePresets(extendedFlavor, flavors);
                    if (parentPresets != null) {
                        presets.addAll(0, parentPresets);
                    }
                } else {
                    log.warn("Extended flavor '{}' not found", (Object)extendedFlavor);
                }
            }
        }
        return presets;
    }

    protected PageRegistry getPageRegistry() {
        return (PageRegistry)this.getExtensionPointRegistry(PAGE_EP);
    }

    @Override
    public String getDefaultFlavorName(String themePageName) {
        return this.getPageRegistry().getContribution(themePageName).map(PageDescriptor.class::cast).map(PageDescriptor::getDefaultFlavor).orElse(null);
    }

    @Override
    public FlavorDescriptor getFlavor(String flavorName) {
        return this.getRegistryContribution(FLAVOR_EP, flavorName).map(desc -> new FlavorDescriptor(flavorName, desc.getLabel(), desc.getExtendsFlavor(), this.computeLogo((FlavorDescriptor)desc, (List<String>)new ArrayList<String>()), this.computePalettePreview((FlavorDescriptor)desc, (List<String>)new ArrayList<String>()), desc.getSassImports(), desc.getPresets(), this.computeIcons((FlavorDescriptor)desc, (List<String>)new ArrayList<String>()))).orElse(null);
    }

    @Override
    public LogoDescriptor getLogo(String flavorName) {
        FlavorDescriptor flavor = this.getFlavor(flavorName);
        if (flavor != null) {
            return flavor.getLogo();
        }
        return null;
    }

    protected LogoDescriptor computeLogo(FlavorDescriptor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            LogoDescriptor localLogo = flavor.getLogo();
            if (localLogo == null && !StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = flavor::getName;
                    log.error("Cyclic dependency detected in flavor '{}' hierarchy", supplierArray);
                    return null;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localLogo = this.computeLogo(extendedFlavor, flavors);
                } else {
                    log.warn("Extended flavor '{}' not found", (Object)extendsFlavorName);
                }
            }
            return localLogo;
        }
        return null;
    }

    protected PalettePreview computePalettePreview(FlavorDescriptor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            PalettePreview localPalette = flavor.getPalettePreview();
            if (localPalette == null && !StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = flavor::getName;
                    log.error("Cyclic dependency detected in flavor '{}' hierarchy", supplierArray);
                    return null;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localPalette = this.computePalettePreview(extendedFlavor, flavors);
                } else {
                    log.warn("Extended flavor '{}' not found", (Object)extendsFlavorName);
                }
            }
            return localPalette;
        }
        return null;
    }

    protected List<IconDescriptor> computeIcons(FlavorDescriptor flavor, List<String> flavors) {
        if (flavor != null) {
            String extendsFlavorName;
            List<IconDescriptor> localIcons = flavor.getFavicons();
            if ((localIcons == null || localIcons.isEmpty()) && !StringUtils.isBlank((CharSequence)(extendsFlavorName = flavor.getExtendsFlavor()))) {
                if (flavors.contains(extendsFlavorName)) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = flavor::getName;
                    log.error("Cyclic dependency detected in flavor '{}' hierarchy", supplierArray);
                    return null;
                }
                flavors.add(flavor.getName());
                FlavorDescriptor extendedFlavor = this.getFlavor(extendsFlavorName);
                if (extendedFlavor != null) {
                    localIcons = this.computeIcons(extendedFlavor, flavors);
                } else {
                    log.warn("Extended flavor '{}' not found", (Object)extendsFlavorName);
                }
            }
            return localIcons;
        }
        return null;
    }

    @Override
    public List<String> getFlavorNames(String themePageName) {
        PageRegistry pageReg = this.getPageRegistry();
        PageDescriptor themePage = pageReg.getPage(themePageName);
        String defaultFlavor = null;
        LinkedHashSet<String> flavors = new LinkedHashSet<String>();
        if (themePage != null) {
            PageDescriptor forAllPage;
            List<String> localFlavors = themePage.getFlavors();
            if (localFlavors != null) {
                flavors.addAll(localFlavors);
            }
            if ((forAllPage = pageReg.getConfigurationApplyingToAll()) != null && (localFlavors = forAllPage.getFlavors()) != null) {
                flavors.addAll(localFlavors);
            }
            defaultFlavor = themePage.getDefaultFlavor();
        }
        ArrayList<String> res = new ArrayList<String>(flavors);
        if (defaultFlavor != null && !flavors.contains(defaultFlavor)) {
            res.add(0, defaultFlavor);
        }
        return res;
    }

    @Override
    public List<FlavorDescriptor> getFlavors(String themePageName) {
        List<String> flavorNames = this.getFlavorNames(themePageName);
        if (flavorNames != null) {
            ArrayList<FlavorDescriptor> flavors = new ArrayList<FlavorDescriptor>();
            for (String flavorName : flavorNames) {
                FlavorDescriptor flavor = this.getFlavor(flavorName);
                if (flavor == null) continue;
                flavors.add(flavor);
            }
            return flavors;
        }
        return null;
    }

    protected Map<String, Map<String, String>> getPresetsByCat(FlavorDescriptor flavor) {
        String flavorName = flavor.getName();
        List<FlavorPresets> presets = this.computePresets(flavor, new ArrayList<String>());
        HashMap<String, Map<String, String>> presetsByCat = new HashMap<String, Map<String, String>>();
        if (presets != null) {
            for (FlavorPresets myPreset : presets) {
                String content = myPreset.getContent();
                if (content == null) {
                    log.error("Null content for preset with source '{}' in flavor '{}'", (Object)myPreset.getSrc(), (Object)flavorName);
                    continue;
                }
                String cat = myPreset.getCategory();
                Map allEntries = presetsByCat.containsKey(cat) ? (Map)presetsByCat.get(cat) : new HashMap();
                try {
                    Map<String, String> newEntries = PaletteParser.parse(content.getBytes(), myPreset.getSrc());
                    if (newEntries != null) {
                        allEntries.putAll(newEntries);
                    }
                    if (allEntries.isEmpty()) {
                        presetsByCat.remove(cat);
                        continue;
                    }
                    presetsByCat.put(cat, allEntries);
                }
                catch (PaletteParseException e) {
                    log.error("Could not parse palette for preset with source '{}' in flavor '{}'", (Object)myPreset.getSrc(), (Object)flavorName, (Object)e);
                }
            }
        }
        return presetsByCat;
    }

    @Override
    public Map<String, String> getPresetVariables(String flavorName) {
        HashMap<String, String> res = new HashMap<String, String>();
        FlavorDescriptor flavor = this.getFlavor(flavorName);
        if (flavor == null) {
            return res;
        }
        Map<String, Map<String, String>> presetsByCat = this.getPresetsByCat(flavor);
        for (String cat : presetsByCat.keySet()) {
            Map<String, String> entries = presetsByCat.get(cat);
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                res.put(entry.getKey() + " (__FLAVOR__ " + cat + ")", entry.getValue());
            }
        }
        return res;
    }

    @Override
    public PageDescriptor getPage(String name) {
        return this.getPageRegistry().getContribution(name).orElse(null);
    }

    @Override
    public List<PageDescriptor> getPages() {
        return this.getPageRegistry().getContributionValues();
    }

    @Override
    public String negotiate(String target, Object context) {
        return this.getRegistryContribution(NEGO_EP, target).map(negd -> {
            List<NegotiatorDescriptor> nds = negd.getNegotiators();
            for (NegotiatorDescriptor nd : nds) {
                Class<Negotiator> ndc = nd.getNegotiatorClass();
                try {
                    Negotiator neg = ndc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    neg.setProperties(nd.getProperties());
                    String res = neg.getResult(target, context);
                    if (res == null) continue;
                    return res;
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }).orElse(null);
    }
}

