/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.IconDescriptor;
import org.nuxeo.theme.styling.service.descriptors.LogoDescriptor;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;
import org.nuxeo.theme.styling.service.descriptors.SassImport;

@XObject(value="flavor")
@XRegistry
public class FlavorDescriptor {
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="label")
    protected String label;
    @XNode(value="@extends")
    protected String extendsFlavor;
    @XNode(value="logo")
    protected LogoDescriptor logo;
    @XNode(value="palettePreview")
    protected PalettePreview palettePreview;
    @XNodeList(value="sass/import", type=ArrayList.class, componentType=SassImport.class)
    @XMerge(value="@merge", fallback="sass@append")
    protected List<SassImport> sassImports = new ArrayList<SassImport>();
    @XNodeList(value="presetsList/presets", type=ArrayList.class, componentType=FlavorPresets.class)
    @XMerge(value="@merge", fallback="presetsList@append")
    protected List<FlavorPresets> presets = new ArrayList<FlavorPresets>();
    @XNodeList(value="links/icon", type=ArrayList.class, componentType=IconDescriptor.class)
    protected List<IconDescriptor> favicons = new ArrayList<IconDescriptor>();

    public FlavorDescriptor() {
    }

    public FlavorDescriptor(String name, String label, String extendsFlavor, LogoDescriptor logo, PalettePreview palettePreview, List<SassImport> sassImports, List<FlavorPresets> presets, List<IconDescriptor> favicons) {
        this.name = name;
        this.label = label;
        this.extendsFlavor = extendsFlavor;
        this.logo = logo;
        this.palettePreview = palettePreview;
        if (sassImports != null) {
            this.sassImports.addAll(sassImports);
        }
        if (presets != null) {
            this.presets = presets;
        }
        if (favicons != null) {
            this.favicons = favicons;
        }
    }

    public String getExtendsFlavor() {
        return this.extendsFlavor;
    }

    public List<IconDescriptor> getFavicons() {
        return this.favicons;
    }

    public String getLabel() {
        return this.label;
    }

    public LogoDescriptor getLogo() {
        return this.logo;
    }

    public String getName() {
        return this.name;
    }

    public PalettePreview getPalettePreview() {
        return this.palettePreview;
    }

    public List<FlavorPresets> getPresets() {
        return Collections.unmodifiableList(this.presets);
    }

    public List<SassImport> getSassImports() {
        return Collections.unmodifiableList(this.sassImports);
    }
}

