/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="page")
@XRegistry
public class PageDescriptor {
    public static final String RESOURCE_BUNDLE_PREFIX = "pageResourceBundle_";
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@charset")
    protected String charset;
    @XNode(value="defaultFlavor")
    protected String defaultFlavor;
    @XNodeList(value="flavors/flavor", type=ArrayList.class, componentType=String.class)
    @XMerge(value="@merge", fallback="flavors@append", defaultAssignment=false)
    protected List<String> flavors = new ArrayList<String>();
    @XNodeList(value="resources/resource", type=ArrayList.class, componentType=String.class)
    @XMerge(value="@merge", fallback="resources@append", defaultAssignment=false)
    protected List<String> resources = new ArrayList<String>();
    @XNodeList(value="resources/bundle", type=ArrayList.class, componentType=String.class)
    @XMerge(value="@merge", fallback="resources@append", defaultAssignment=false)
    List<String> bundles = new ArrayList<String>();

    public PageDescriptor() {
    }

    public PageDescriptor(String name, String charset, String defaultFlavor, List<String> flavors, List<String> resources, List<String> bundles) {
        this.name = name;
        this.charset = charset;
        this.defaultFlavor = defaultFlavor;
        if (flavors != null) {
            this.flavors.addAll(flavors);
        }
        if (resources != null) {
            this.resources.addAll(resources);
        }
        if (bundles != null) {
            this.bundles.addAll(bundles);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultFlavor() {
        return this.defaultFlavor;
    }

    public List<String> getFlavors() {
        return this.flavors;
    }

    public boolean hasResources() {
        return !this.getResources().isEmpty();
    }

    public List<String> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public String getComputedResourceBundleName() {
        if ("*".equals(this.getName())) {
            return "pageResourceBundle_*";
        }
        return RESOURCE_BUNDLE_PREFIX + this.getName().replaceAll("[^a-zA-Z]+", "_");
    }

    public List<String> getDeclaredResourceBundles() {
        return Collections.unmodifiableList(this.bundles);
    }

    public List<String> getResourceBundles() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        if (this.bundles != null) {
            all.addAll(this.bundles);
        }
        if (this.hasResources()) {
            all.add(this.getComputedResourceBundleName());
        }
        return new ArrayList<String>(all);
    }

    public String getCharset() {
        return this.charset;
    }
}

