/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dmk;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorServer;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.internal.JDMKServerConnector;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.dmk.DmkProtocol;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class DmkComponent
extends DefaultComponent {
    private static final Logger log = LogManager.getLogger(DmkComponent.class);
    protected static final String XP = "protocols";
    protected HtmlAdaptorServer htmlAdaptor;
    protected JDMKServerConnector httpConnector;
    protected JDMKServerConnector httpsConnector;
    protected final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();

    protected HtmlAdaptorServer newAdaptor(DmkProtocol config) {
        HtmlAdaptorServer adaptor = new HtmlAdaptorServer();
        adaptor.addUserAuthenticationInfo(new AuthInfo(config.user, config.password));
        adaptor.setPort(config.port);
        try {
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-adaptor,format=html");
            this.mbs.registerMBean(adaptor, name);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        return adaptor;
    }

    protected void destroyAdaptor(HtmlAdaptorServer adaptor) {
        try {
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-adaptor,format=html");
            this.mbs.unregisterMBean(name);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        if (!adaptor.isActive()) {
            return;
        }
        adaptor.stop();
    }

    protected JDMKServerConnector newConnector(DmkProtocol config) {
        try {
            String protocol = "jdmk-".concat(config.name);
            JMXServiceURL httpURL = new JMXServiceURL(protocol, null, config.port);
            JDMKServerConnector connector = (JDMKServerConnector)JMXConnectorServerFactory.newJMXConnectorServer(httpURL, null, this.mbs);
            GenericHttpConnectorServer server = (GenericHttpConnectorServer)connector.getWrapped();
            server.addUserAuthenticationInfo(new AuthInfo(config.user, config.password));
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-connector,protocol=".concat(protocol));
            this.mbs.registerMBean(connector, name);
            return connector;
        }
        catch (IOException | JMException e) {
            throw new RuntimeException(e);
        }
    }

    protected void destroyConnector(JDMKServerConnector connector) {
        String protocol = connector.getAddress().getProtocol();
        try {
            ObjectName name = new ObjectName("org.nuxeo:type=jmx-connector,protocol=".concat(protocol));
            this.mbs.unregisterMBean(name);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        if (!connector.isActive()) {
            return;
        }
        try {
            connector.stop();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(ComponentContext context) {
        Map configs = ((MapRegistry)this.getExtensionPointRegistry(XP)).getContributions();
        if (configs.containsKey("html")) {
            this.htmlAdaptor = this.newAdaptor((DmkProtocol)configs.get("html"));
            log.info("JMX HTML adaptor available at port 8081 (not active, to be started in JMX console)");
        }
        if (configs.containsKey("http")) {
            this.httpConnector = this.newConnector((DmkProtocol)configs.get("http"));
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((JDMKServerConnector)this.httpConnector).getAddress();
            log.info("JMX HTTP connector available at {} (not active, to be started in JMX console)", supplierArray);
        }
        if (configs.containsKey("https")) {
            this.httpsConnector = this.newConnector((DmkProtocol)configs.get("https"));
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((JDMKServerConnector)this.httpConnector).getAddress();
            log.info("JMX HTTPS connector available at {} (not active, to be started in JMX console)", supplierArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ComponentContext arg0) {
        if (this.htmlAdaptor != null) {
            try {
                this.destroyAdaptor(this.htmlAdaptor);
            }
            finally {
                this.htmlAdaptor = null;
            }
        }
        if (this.httpConnector != null) {
            try {
                this.destroyConnector(this.httpConnector);
            }
            finally {
                this.httpConnector = null;
            }
        }
        if (this.httpsConnector != null) {
            try {
                this.destroyConnector(this.httpsConnector);
            }
            finally {
                this.httpsConnector = null;
            }
        }
    }
}

