/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeGetResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.security.SslFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(CachedSchemaRegistryClient.class);
    private final RestService restService;
    private final int identityMapCapacity;
    private final Map<String, Map<ParsedSchema, Integer>> schemaCache;
    private final Map<String, Map<Integer, ParsedSchema>> idCache;
    private final Map<String, Map<ParsedSchema, Integer>> versionCache;
    private final Map<String, SchemaProvider> providers;
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity) {
        this(new RestService(baseUrl), identityMapCapacity);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity) {
        this(new RestService(baseUrls), identityMapCapacity);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity) {
        this(restService, identityMapCapacity, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity, Map<String, ?> originals) {
        this(baseUrl, identityMapCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity, Map<String, ?> originals) {
        this(baseUrls, identityMapCapacity, originals, null);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity, List<SchemaProvider> providers, Map<String, ?> originals) {
        this(new RestService(baseUrls), identityMapCapacity, providers, originals, null);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity, Map<String, ?> configs) {
        this(restService, identityMapCapacity, null, configs, null);
    }

    public CachedSchemaRegistryClient(String baseUrl, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrl), identityMapCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), identityMapCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(List<String> baseUrls, int identityMapCapacity, List<SchemaProvider> providers, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(new RestService(baseUrls), identityMapCapacity, providers, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity, Map<String, ?> originals, Map<String, String> httpHeaders) {
        this(restService, identityMapCapacity, null, originals, httpHeaders);
    }

    public CachedSchemaRegistryClient(RestService restService, int identityMapCapacity, List<SchemaProvider> providers, Map<String, ?> configs, Map<String, String> httpHeaders) {
        log.debug("CachedSchemaRegistryClient configs: {}", configs);
        this.identityMapCapacity = identityMapCapacity;
        this.schemaCache = new HashMap<String, Map<ParsedSchema, Integer>>();
        this.idCache = new HashMap<String, Map<Integer, ParsedSchema>>();
        this.versionCache = new HashMap<String, Map<ParsedSchema, Integer>>();
        this.restService = restService;
        this.idCache.put(null, new HashMap());
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(p -> p.schemaType(), p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, CachedSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, CachedSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
        if (httpHeaders != null) {
            restService.setHttpHeaders(httpHeaders);
        }
        if (configs != null && !configs.isEmpty()) {
            Map<String, Object> restConfigs = configs.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("schema.registry.") ? ((String)e.getKey()).substring("schema.registry.".length()) : (String)e.getKey(), Map.Entry::getValue, (existing, replacement) -> replacement));
            restService.configure(restConfigs);
            Map<String, Object> sslConfigs = configs.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("schema.registry.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("schema.registry.".length()), Map.Entry::getValue));
            SslFactory sslFactory = new SslFactory(sslConfigs);
            if (sslFactory != null && sslFactory.sslContext() != null) {
                restService.setSslSocketFactory(sslFactory.sslContext().getSocketFactory());
            }
        }
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        SchemaProvider schemaProvider;
        if (schemaType == null) {
            schemaType = "AVRO";
        }
        if ((schemaProvider = this.providers.get(schemaType)) == null) {
            log.error("Invalid schema type " + schemaType);
            return Optional.empty();
        }
        return schemaProvider.parseSchema(schemaString, references);
    }

    public Map<String, SchemaProvider> getSchemaProviders() {
        return this.providers;
    }

    private int registerAndGetId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.canonicalString(), schema.schemaType(), schema.references(), subject);
    }

    private int registerAndGetId(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.restService.registerSchema(schema.canonicalString(), schema.schemaType(), schema.references(), subject, version, id);
    }

    protected ParsedSchema getSchemaByIdFromRegistry(int id) throws IOException, RestClientException {
        SchemaString restSchema = this.restService.getId(id);
        Optional<ParsedSchema> schema = this.parseSchema(restSchema.getSchemaType(), restSchema.getSchemaString(), restSchema.getReferences());
        return schema.orElseThrow(() -> new IOException("Invalid schema " + restSchema.getSchemaString() + " with refs " + restSchema.getReferences() + " of type " + restSchema.getSchemaType()));
    }

    private int getVersionFromRegistry(String subject, ParsedSchema schema) throws IOException, RestClientException {
        Schema response = this.restService.lookUpSubjectVersion(schema.canonicalString(), schema.schemaType(), schema.references(), subject, true);
        return response.getVersion();
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema) throws IOException, RestClientException {
        Schema response = this.restService.lookUpSubjectVersion(schema.canonicalString(), schema.schemaType(), schema.references(), subject, false);
        return response.getId();
    }

    @Override
    public synchronized int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public synchronized int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new HashMap());
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            if (id >= 0 && id != cachedId) {
                throw new IllegalStateException("Schema already registered with id " + cachedId + " instead of input id " + id);
            }
            return cachedId;
        }
        if (schemaIdMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int retrievedId = id >= 0 ? this.registerAndGetId(subject, schema, version, id) : this.registerAndGetId(subject, schema);
        schemaIdMap.put(schema, retrievedId);
        this.idCache.get(null).put(retrievedId, schema);
        return retrievedId;
    }

    @Override
    public synchronized ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(null, id);
    }

    @Override
    public synchronized ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap = this.idCache.computeIfAbsent(subject, k -> new HashMap());
        ParsedSchema cachedSchema = (ParsedSchema)idSchemaMap.get(id);
        if (cachedSchema != null) {
            return cachedSchema;
        }
        ParsedSchema retrievedSchema = this.getSchemaByIdFromRegistry(id);
        idSchemaMap.put(id, retrievedSchema);
        return retrievedSchema;
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.restService.getAllSubjectsById(id);
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.restService.getAllVersionsById(id);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        try {
            return this.restService.getVersion(subject, version, lookupDeletedSchema);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        Schema response = this.restService.getVersion(subject, version);
        int id = response.getId();
        String schemaType = response.getSchemaType();
        String schema = response.getSchema();
        List<SchemaReference> references = response.getReferences();
        return new SchemaMetadata(id, version, schemaType, references, schema);
    }

    @Override
    public synchronized SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        Schema response = this.restService.getLatestVersion(subject);
        int id = response.getId();
        int version = response.getVersion();
        String schemaType = response.getSchemaType();
        String schema = response.getSchema();
        List<SchemaReference> references = response.getReferences();
        return new SchemaMetadata(id, version, schemaType, references, schema);
    }

    @Override
    public synchronized int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        Map schemaVersionMap = this.versionCache.computeIfAbsent(subject, k -> new HashMap());
        Integer cachedVersion = (Integer)schemaVersionMap.get(schema);
        if (cachedVersion != null) {
            return cachedVersion;
        }
        if (schemaVersionMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int retrievedVersion = this.getVersionFromRegistry(subject, schema);
        schemaVersionMap.put(schema, retrievedVersion);
        return retrievedVersion;
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.restService.getAllVersions(subject);
    }

    @Override
    public synchronized int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        Map schemaIdMap = this.schemaCache.computeIfAbsent(subject, k -> new HashMap());
        Integer cachedId = (Integer)schemaIdMap.get(schema);
        if (cachedId != null) {
            return cachedId;
        }
        if (schemaIdMap.size() >= this.identityMapCapacity) {
            throw new IllegalStateException("Too many schema objects created for " + subject + "!");
        }
        int retrievedId = this.getIdFromRegistry(subject, schema);
        schemaIdMap.put(schema, retrievedId);
        this.idCache.get(null).put(retrievedId, schema);
        return retrievedId;
    }

    @Override
    public List<Integer> deleteSubject(String subject) throws IOException, RestClientException {
        return this.deleteSubject(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        Objects.requireNonNull(subject, "subject");
        this.versionCache.remove(subject);
        this.idCache.remove(subject);
        this.schemaCache.remove(subject);
        return this.restService.deleteSubject(requestProperties, subject);
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version) throws IOException, RestClientException {
        return this.deleteSchemaVersion(DEFAULT_REQUEST_PROPERTIES, subject, version);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        this.versionCache.getOrDefault(subject, Collections.emptyMap()).values().remove(Integer.valueOf(version));
        return this.restService.deleteSchemaVersion(requestProperties, subject, version);
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.restService.testCompatibility(schema.canonicalString(), schema.schemaType(), schema.references(), subject, "latest");
    }

    @Override
    public String updateCompatibility(String subject, String compatibility) throws IOException, RestClientException {
        ConfigUpdateRequest response = this.restService.updateCompatibility(compatibility, subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public String getCompatibility(String subject) throws IOException, RestClientException {
        Config response = this.restService.getConfig(subject);
        return response.getCompatibilityLevel();
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode);
        return response.getMode();
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        ModeUpdateRequest response = this.restService.setMode(mode, subject);
        return response.getMode();
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        ModeGetResponse response = this.restService.getMode();
        return response.getMode();
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        ModeGetResponse response = this.restService.getMode(subject);
        return response.getMode();
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        return this.restService.getAllSubjects();
    }

    @Override
    public void reset() {
        this.schemaCache.clear();
        this.idCache.clear();
        this.versionCache.clear();
        this.idCache.put(null, new HashMap());
    }
}

