/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.time.Duration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;

@XObject(value="command")
@XRegistry(enable=false, compatWarnOnMerge=true)
public class CommandLineDescriptor {
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected boolean enabled;
    @XNode(value="commandLine")
    protected String command;
    @XNode(value="parameterString", defaultAssignment="")
    protected String parameterString;
    @XNode(value="testParameterString", defaultAssignment="")
    protected String testParameterString;
    @XNode(value="winParameterString")
    protected String winParameterString;
    @XNode(value="winTestParameterString")
    protected String winTestParameterString;
    @XNode(value="winCommand")
    protected String winCommand;
    @XNode(value="tester")
    protected String tester;
    @XNode(value="readOutput", defaultAssignment="true")
    protected boolean readOutput;
    @XNode(value="installationDirective")
    protected String installationDirective;
    @XNode(value="timeout")
    public Duration timeout;
    @Deprecated(since="11.5")
    protected boolean available;
    @Deprecated(since="11.5")
    protected String installErrorMessage;

    public String getName() {
        if (this.name == null) {
            return this.getCommand();
        }
        return this.name;
    }

    public String getCommand() {
        if (SystemUtils.IS_OS_WINDOWS && this.winCommand != null) {
            return this.winCommand;
        }
        return this.command;
    }

    public String getInstallationDirective() {
        return this.installationDirective;
    }

    public String getTester() {
        return this.tester;
    }

    public boolean getReadOutput() {
        return this.readOutput;
    }

    public String getParametersString() {
        if (SystemUtils.IS_OS_WINDOWS && this.winParameterString != null) {
            return this.winParameterString;
        }
        return this.parameterString;
    }

    public String getTestParametersString() {
        if (SystemUtils.IS_OS_WINDOWS && this.winTestParameterString != null) {
            return this.winTestParameterString;
        }
        return this.testParameterString;
    }

    @Deprecated(since="11.5")
    public String getExecutor() {
        return "ShellExecutor";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Deprecated(since="11.5")
    public boolean isAvailable() {
        return this.available;
    }

    @Deprecated(since="11.5")
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Deprecated(since="11.5")
    public String getInstallErrorMessage() {
        return this.installErrorMessage;
    }

    @Deprecated(since="11.5")
    public void setInstallErrorMessage(String installErrorMessage) {
        this.installErrorMessage = installErrorMessage;
    }

    public Duration getTimeout() {
        return this.timeout;
    }
}

