/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.EnvironmentDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters.CommandTestResult;
import org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters.CommandTester;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.ShellExecutor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class CommandLineExecutorComponent
extends DefaultComponent
implements CommandLineExecutorService {
    private static final Logger log = LogManager.getLogger(CommandLineExecutorComponent.class);
    public static final String EP_ENV = "environment";
    public static final String EP_CMD = "command";
    public static final String EP_CMDTESTER = "commandTester";
    public static final String DEFAULT_TESTER = "DefaultCommandTester";
    public static final String DEFAULT_EXECUTOR = "ShellExecutor";
    protected Executor defaultExecutorInstance;
    protected Map<String, CommandAvailability> unavailableCommands;
    protected boolean useTimeout;

    public void start(ComponentContext context) {
        ((MapRegistry)this.getExtensionPointRegistry(EP_ENV)).getContributions().keySet().stream().filter(name -> name.contains(",")).forEach(name -> {
            String msg = String.format("Since version 11.5, contributions to extension point '%s--%s' do not accept comma-separated names to match multiple commands or command lines anymore: contribution with name '%s' should be duplicated", "org.nuxeo.ecm.platform.commandline.executor.service.CommandLineExecutorComponent", EP_ENV, name);
            this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
            log.error(msg);
        });
        HashMap testers = new HashMap();
        this.getRegistryContributions(EP_CMDTESTER).forEach(desc -> {
            try {
                CommandTester tester = desc.getTesterClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                testers.put(desc.getName(), tester);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)e, (Throwable)e);
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, e.getMessage());
            }
        });
        this.unavailableCommands = new HashMap<String, CommandAvailability>();
        this.getRegistryContributions(EP_CMD).forEach(desc -> {
            CommandTester tester;
            String name = desc.getName();
            String testerName = desc.getTester();
            if (testerName == null) {
                testerName = DEFAULT_TESTER;
                log.debug("Using default tester for command: {}", (Object)name);
            }
            if ((tester = (CommandTester)testers.get(testerName)) == null) {
                String error = String.format("Unable to find tester '%s', command will not be available: '%s'", testerName, name);
                this.addRuntimeMessage(RuntimeMessage.Level.WARNING, error);
                log.error(error);
                this.unavailableCommands.put(name, new CommandAvailability(desc.getInstallationDirective(), error));
            } else {
                log.debug("Using tester '{}' for command: {}", (Object)testerName, (Object)name);
                CommandTestResult testResult = tester.test((CommandLineDescriptor)desc);
                if (testResult.succeed()) {
                    log.info("Registered command: {}", (Object)name);
                } else {
                    String error = testResult.getErrorMessage();
                    String warn = String.format("Command not available: %s (%s. %s)", name, error, desc.getInstallationDirective());
                    log.warn(warn);
                    this.unavailableCommands.put(name, new CommandAvailability(desc.getInstallationDirective(), error));
                }
            }
        });
        this.checkIfTimeoutIsAvailable();
        this.defaultExecutorInstance = new ShellExecutor(this.useTimeout);
    }

    protected void checkIfTimeoutIsAvailable() {
        if (SystemUtils.IS_OS_WINDOWS || this.unavailableCommands.containsKey("timeout")) {
            log.warn("There is no timeout command available, command executions won't be time-boxed.");
            return;
        }
        log.debug("Using timeout to limit time execution of commands.");
        this.useTimeout = true;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.unavailableCommands = null;
    }

    @Override
    public ExecResult execCommand(String commandName, CmdParameters params) throws CommandNotAvailable {
        CommandAvailability availability = this.getCommandAvailability(commandName);
        if (!availability.isAvailable()) {
            throw new CommandNotAvailable(availability);
        }
        CommandLineDescriptor cmdDesc = (CommandLineDescriptor)this.getRegistryContribution(EP_CMD, commandName).orElseThrow(() -> new RuntimeException("Command " + commandName + " is not available"));
        EnvironmentDescriptor globalEnv = this.getRegistryContribution(EP_ENV, this.name).orElse(null);
        EnvironmentDescriptor commandEnv = this.getRegistryContribution(EP_ENV, commandName).or(() -> this.getRegistryContribution(EP_ENV, cmdDesc.getCommand())).orElse(null);
        EnvironmentDescriptor env = new EnvironmentDescriptor().merge(globalEnv).merge(commandEnv);
        return this.defaultExecutorInstance.exec(cmdDesc, params, env);
    }

    @Override
    public CommandAvailability getCommandAvailability(String commandName) {
        CommandAvailability avail = this.unavailableCommands.get(commandName);
        if (avail != null) {
            return avail;
        }
        return this.getRegistryContribution(EP_CMD, commandName).map(desc -> new CommandAvailability()).orElse(new CommandAvailability(commandName + " is not a registered command"));
    }

    @Override
    public List<String> getRegistredCommands() {
        return new ArrayList<String>(((MapRegistry)this.getExtensionPointRegistry(EP_CMD)).getContributions().keySet());
    }

    @Override
    public List<String> getAvailableCommands() {
        return this.getRegistredCommands().stream().filter(Predicate.not(this.unavailableCommands::containsKey)).collect(Collectors.toList());
    }

    @Override
    public CommandLineDescriptor getCommandLineDescriptor(String commandName) {
        return this.getRegistryContribution(EP_CMD, commandName).orElse(null);
    }

    @Deprecated(since="11.4")
    public static CommandLineDescriptor getCommandDescriptor(String commandName) {
        return ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).getCommandLineDescriptor(commandName);
    }

    @Override
    public CmdParameters getDefaultCmdParameters() {
        CmdParameters params = new CmdParameters();
        params.addNamedParameter("java.io.tmpdir", System.getProperty("java.io.tmpdir"));
        params.addNamedParameter("nuxeo.tmp.dir", Environment.getDefault().getTemp().getPath());
        return params;
    }
}

