/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;

public class Log4jWebFilter
implements Filter {
    private static final Log log = LogFactory.getLog(Log4jWebFilter.class);
    protected FilterConfig config;

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.putProperty(request, "RemoteAddr");
            this.putProperty(request, "PathInfo");
            this.putProperty(request, "RequestURL");
            this.putProperty(request, "ServletPath");
            this.putProperty(request, "UserPrincipal");
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            if (session != null) {
                ThreadContext.put((String)"SessionID", (String)session.getId());
            }
            chain.doFilter(request, response);
        }
        finally {
            ThreadContext.remove((String)"RemoteAddr");
            ThreadContext.remove((String)"PathInfo");
            ThreadContext.remove((String)"RequestURL");
            ThreadContext.remove((String)"ServletPath");
            ThreadContext.remove((String)"UserPrincipal");
            ThreadContext.remove((String)"SessionID");
        }
    }

    protected void putProperty(Object object, String propertyName) {
        try {
            String name;
            Object prop;
            if (object != null && (prop = PropertyUtils.getProperty((Object)object, (String)(name = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1)))) != null) {
                ThreadContext.put((String)propertyName, (String)prop.toString());
            }
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

