/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TracingWebFilter
extends HttpFilter {
    protected FilterConfig config;
    protected static final String USER_KEY = "http.user";
    protected static final String THREAD_KEY = "http.thread";
    protected static final String SESSION_KEY = "http.session";

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
    }

    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        Span span = Tracing.getTracer().getCurrentSpan();
        this.addTags(span, req);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    protected void addTags(Span span, HttpServletRequest httpRequest) {
        HttpSession session;
        if (span instanceof BlankSpan) {
            return;
        }
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        map.put(THREAD_KEY, AttributeValue.stringAttributeValue((String)Thread.currentThread().getName()));
        Principal principal = httpRequest.getUserPrincipal();
        if (principal != null) {
            map.put(USER_KEY, AttributeValue.stringAttributeValue((String)principal.getName()));
        }
        if ((session = httpRequest.getSession(false)) != null) {
            map.put(SESSION_KEY, AttributeValue.stringAttributeValue((String)session.getId()));
        }
        span.putAttributes(map);
    }
}

