/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.osgi.application.DevMutableClassLoader;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.reload.ReloadContext;
import org.nuxeo.runtime.reload.ReloadResult;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.util.Watch;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ReloadComponent
extends DefaultComponent
implements ReloadService {
    public static final String RELOAD_STRATEGY_PARAMETER = "org.nuxeo.runtime.reload_strategy";
    public static final String RELOAD_STRATEGY_VALUE_UNSTASH = "unstash";
    public static final String RELOAD_STRATEGY_VALUE_STANDBY = "standby";
    public static final String RELOAD_STRATEGY_VALUE_RESTART = "restart";
    public static final String RELOAD_STRATEGY_VALUE_DEFAULT = "standby";
    private static final Logger log = LogManager.getLogger(ReloadComponent.class);
    protected static Bundle bundle;
    protected Long lastFlushed;

    public static BundleContext getBundleContext() {
        return bundle.getBundleContext();
    }

    public static Bundle getBundle() {
        return bundle;
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        bundle = context.getRuntimeContext().getBundle();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        bundle = null;
    }

    @Deprecated(since="9.3")
    protected void refreshComponents() {
        String reloadStrategy = Framework.getProperty((String)RELOAD_STRATEGY_PARAMETER, (String)"standby");
        log.info("Refresh components. Strategy={}", (Object)reloadStrategy);
        ComponentManager mgr = Framework.getRuntime().getComponentManager();
        switch (reloadStrategy) {
            case "unstash": {
                mgr.unstash();
                break;
            }
            case "standby": {
                mgr.standby();
                mgr.unstash();
                mgr.resume();
                break;
            }
            default: {
                mgr.refresh(false);
            }
        }
    }

    @Override
    public void reload() {
        log.debug("Starting reload");
        try {
            this.reloadProperties();
        }
        catch (IOException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
        this.triggerReloadWithNewTransaction("reload");
    }

    @Override
    public void reloadProperties() throws IOException {
        log.info("Before reload runtime properties");
        Framework.getRuntime().reloadProperties();
        log.info("After reload runtime properties");
    }

    @Override
    public void reloadSeamComponents() {
        log.info("Reload Seam components");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "reloadSeamComponents", (Object)this, null));
    }

    @Override
    public void flush() {
        log.info("Before flush caches");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "flush", (Object)this, null));
        this.flushJaasCache();
        this.setFlushedNow();
        log.info("After flush caches");
    }

    @Override
    public void flushJaasCache() {
        log.info("Before flush the JAAS cache");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("usermanager", "user_changed", (Object)this, (Object)"Deployer"));
        this.setFlushedNow();
        log.info("After flush the JAAS cache");
    }

    @Override
    public void flushSeamComponents() {
        log.info("Flush Seam components");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "flushSeamComponents", (Object)this, null));
        this.setFlushedNow();
    }

    @Override
    @Deprecated(since="9.3")
    public void deployBundles(List<File> files, boolean reloadResources) throws BundleException {
        BundleException exc;
        long begin = System.currentTimeMillis();
        List<String> missingNames = files.stream().filter(file -> this.getOSGIBundleName((File)file) == null).map(File::getAbsolutePath).collect(Collectors.toList());
        if (!missingNames.isEmpty()) {
            missingNames.forEach(name -> log.error("No Bundle-SymbolicName found in MANIFEST for jar at '{}'", name));
            return;
        }
        log.info(() -> {
            StringBuilder builder = new StringBuilder("Before deploy bundles\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
        if (reloadResources) {
            List urls = files.stream().map(this::toURL).collect(Collectors.toList());
            Framework.reloadResourceLoader(urls, null);
        }
        if ((exc = (BundleException)((Object)TransactionHelper.runWithoutTransaction(() -> {
            try {
                this._deployBundles(files);
                this.refreshComponents();
                return null;
            }
            catch (BundleException e) {
                return e;
            }
        }))) != null) {
            throw exc;
        }
        log.info(() -> {
            StringBuilder builder = new StringBuilder("After deploy bundles.\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
        log.info("Hot deploy was done in {} ms.", (Object)(System.currentTimeMillis() - begin));
    }

    @Override
    @Deprecated(since="9.3")
    public void undeployBundles(List<String> bundleNames, boolean reloadResources) throws BundleException {
        long begin = System.currentTimeMillis();
        log.info(() -> {
            StringBuilder builder = new StringBuilder("Before undeploy bundles\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
        ReloadResult result = new ReloadResult();
        BundleException exc = (BundleException)((Object)TransactionHelper.runWithoutTransaction(() -> {
            try {
                result.merge(this._undeployBundles(bundleNames));
                this.refreshComponents();
                return null;
            }
            catch (BundleException e) {
                return e;
            }
        }));
        if (exc != null) {
            throw exc;
        }
        if (reloadResources) {
            List undeployedBundleURLs = result.undeployedBundles.stream().map(this::toURL).collect(Collectors.toList());
            Framework.reloadResourceLoader(null, undeployedBundleURLs);
        }
        log.info(() -> {
            StringBuilder builder = new StringBuilder("After undeploy bundles.\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
        log.info("Hot undeploy was done in {} ms.", (Object)(System.currentTimeMillis() - begin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ReloadResult reloadBundles(ReloadContext context) throws BundleException {
        ReloadResult result = new ReloadResult();
        List<String> bundlesNamesToUndeploy = context.bundlesNamesToUndeploy;
        Watch watch = new Watch(new LinkedHashMap()).start();
        log.info(() -> {
            StringBuilder builder = new StringBuilder("Before updating Nuxeo server\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
        Optional<DevMutableClassLoader> classLoader = Optional.of(this.getClass().getClassLoader()).filter(DevMutableClassLoader.class::isInstance).map(DevMutableClassLoader.class::cast);
        watch.start("flush");
        this.flush();
        watch.stop("flush");
        if (TransactionHelper.isTransactionMarkedRollback()) {
            throw new BundleException("Cannot reload bundles when transaction is marked rollback");
        }
        boolean activeTransaction = TransactionHelper.isTransactionActive();
        if (activeTransaction) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        try {
            ComponentManager componentManager = Framework.getRuntime().getComponentManager();
            String reloadStrategy = Framework.getProperty((String)RELOAD_STRATEGY_PARAMETER, (String)"standby");
            log.info("Component reload strategy={}", (Object)reloadStrategy);
            watch.start("stop/standby");
            log.info("Before stop/standby component manager");
            if (RELOAD_STRATEGY_VALUE_RESTART.equals(reloadStrategy)) {
                componentManager.stop();
            } else {
                componentManager.standby();
            }
            log.info("After stop/standby component manager");
            watch.stop("stop/standby");
            if (!bundlesNamesToUndeploy.isEmpty()) {
                watch.start("undeploy-bundles");
                log.info("Before undeploy bundles");
                this.logComponentManagerStatus();
                result.merge(this._undeployBundles(bundlesNamesToUndeploy));
                this.clearJarFileFactoryCache(result);
                componentManager.unstash();
                classLoader.ifPresent(DevMutableClassLoader::clearPreviousClassLoader);
                log.info("After undeploy bundles");
                this.logComponentManagerStatus();
                watch.stop("undeploy-bundles");
            }
            watch.start("delete-copy");
            log.info("Before delete-copy");
            List urlsToRemove = result.undeployedBundles.stream().map(Bundle::getLocation).map(File::new).peek(File::delete).map(this::toURL).collect(Collectors.toList());
            List<File> bundlesToDeploy = this.copyBundlesToDeploy(context);
            List urlsToAdd = bundlesToDeploy.stream().map(this::toURL).collect(Collectors.toList());
            log.info("After delete-copy");
            watch.stop("delete-copy");
            watch.start("reload-resources");
            Framework.reloadResourceLoader(urlsToAdd, urlsToRemove);
            watch.stop("reload-resources");
            if (!bundlesToDeploy.isEmpty()) {
                watch.start("deploy-bundles");
                log.info("Before deploy bundles");
                this.logComponentManagerStatus();
                classLoader.ifPresent(cl -> cl.addClassLoader(urlsToAdd.toArray(new URL[0])));
                result.merge(this._deployBundles(bundlesToDeploy));
                componentManager.unstash();
                log.info("After deploy bundles");
                this.logComponentManagerStatus();
                watch.stop("deploy-bundles");
            }
            watch.start("start/resume");
            log.info("Before start/resume component manager");
            if (RELOAD_STRATEGY_VALUE_RESTART.equals(reloadStrategy)) {
                componentManager.start();
            } else {
                componentManager.resume();
            }
            log.info("After start/resume component manager");
            watch.stop("start/resume");
            try {
                watch.start("deployment-preprocessor");
                this.runDeploymentPreprocessor();
                watch.stop("deployment-preprocessor");
            }
            catch (IOException e) {
                throw new BundleException("Unable to run deployment preprocessor", (Throwable)e);
            }
            try {
                watch.start("reload-properties");
                this.reloadProperties();
                watch.stop("reload-properties");
            }
            catch (IOException e) {
                throw new BundleException("Unable to reload properties", (Throwable)e);
            }
        }
        finally {
            if (activeTransaction) {
                TransactionHelper.startTransaction();
            }
        }
        log.info(() -> {
            StringBuilder builder = new StringBuilder("After updating Nuxeo server\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
        watch.stop();
        log.info("Hot reload was done in {} ms, detailed steps:\n{}", new Supplier[]{() -> watch.getTotal().elapsed(TimeUnit.MILLISECONDS), () -> Stream.of(watch.getIntervals()).map(i -> "- " + i.getName() + ": " + i.elapsed(TimeUnit.MILLISECONDS) + " ms").collect(Collectors.joining("\n"))});
        return result;
    }

    protected List<File> copyBundlesToDeploy(ReloadContext context) throws BundleException {
        ArrayList<File> bundlesToDeploy = new ArrayList<File>();
        Path homePath = Framework.getRuntime().getHome().toPath();
        Path destinationPath = homePath.resolve(context.bundlesDestination);
        try {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
            for (File bundle : context.bundlesToDeploy) {
                Path bundlePath = bundle.toPath();
                if (!bundlePath.startsWith(destinationPath)) {
                    if (Files.isDirectory(bundlePath, new LinkOption[0])) {
                        bundlePath = JarUtils.zipDirectory((Path)bundlePath, (Path)destinationPath.resolve("hotreload-bundle-" + System.currentTimeMillis() + ".jar"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    } else {
                        bundlePath = destinationPath.resolve(bundle.getName());
                        org.apache.commons.io.FileUtils.copyFile((File)bundle, (File)bundlePath.toFile(), (boolean)false);
                    }
                }
                bundlesToDeploy.add(bundlePath.toFile());
            }
            return bundlesToDeploy;
        }
        catch (IOException e) {
            throw new BundleException("Unable to copy bundles to " + destinationPath, (Throwable)e);
        }
    }

    protected ReloadResult _deployBundles(List<File> bundlesToDeploy) throws BundleException {
        ReloadResult result = new ReloadResult();
        BundleContext bundleContext = ReloadComponent.getBundleContext();
        for (File file : bundlesToDeploy) {
            String path = file.getAbsolutePath();
            log.info("Before deploy bundle for file at '{}'", (Object)path);
            Bundle bundle = bundleContext.installBundle(path);
            if (bundle == null) {
                throw new IllegalArgumentException("Could not find a valid bundle at path: " + path);
            }
            bundle.start();
            result.deployedBundles.add(bundle);
            log.info("Deploy done for bundle with name '{}'", (Object)bundle.getSymbolicName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReloadResult _undeployBundles(List<String> bundleNames) throws BundleException {
        ReloadResult result = new ReloadResult();
        BundleContext ctx = ReloadComponent.getBundleContext();
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin srv = (PackageAdmin)ctx.getService(ref);
        try {
            for (String bundleName : bundleNames) {
                for (Bundle bundle : srv.getBundles(bundleName, null)) {
                    if (bundle == null || bundle.getState() != 32) continue;
                    log.info("Before undeploy bundle with name '{}'.", (Object)bundleName);
                    bundle.stop();
                    bundle.uninstall();
                    result.undeployedBundles.add(bundle);
                    log.info("After undeploy bundle with name '{}'.", (Object)bundleName);
                }
            }
        }
        finally {
            ctx.ungetService(ref);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearJarFileFactoryCache(ReloadResult result) {
        try {
            List jarLocations = result.undeployedBundlesAsStream().map(Bundle::getLocation).collect(Collectors.toList());
            log.debug("Clear JarFileFactory caches for jars={}", jarLocations);
            Class<?> jarFileFactory = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            Object factoryInstance = FieldUtils.readStaticField(jarFileFactory, (String)"instance", (boolean)true);
            Map fileCache = (Map)FieldUtils.readStaticField(jarFileFactory, (String)"fileCache", (boolean)true);
            Map urlCache = (Map)FieldUtils.readStaticField(jarFileFactory, (String)"urlCache", (boolean)true);
            Object object = factoryInstance;
            synchronized (object) {
                Object remove;
                ArrayList<JarFile> urlCacheRemoveKeys = new ArrayList<JarFile>();
                for (Map.Entry entry : urlCache.entrySet()) {
                    JarFile jarFile = (JarFile)entry.getKey();
                    if (!jarLocations.stream().anyMatch(jar -> jar.startsWith(jarFile.getName()))) continue;
                    urlCacheRemoveKeys.add(jarFile);
                }
                ArrayList<String> fileCacheRemoveKeys = new ArrayList<String>();
                for (Map.Entry entry : fileCache.entrySet()) {
                    if (!urlCacheRemoveKeys.contains(entry.getValue())) continue;
                    fileCacheRemoveKeys.add((String)entry.getKey());
                }
                for (String fileCacheRemoveKey : fileCacheRemoveKeys) {
                    remove = (JarFile)fileCache.remove(fileCacheRemoveKey);
                    if (remove == null) continue;
                    log.trace("Removed item from fileCache={}", remove);
                }
                for (JarFile urlCacheRemoveKey : urlCacheRemoveKeys) {
                    remove = (URL)urlCache.remove(urlCacheRemoveKey);
                    try {
                        urlCacheRemoveKey.close();
                    }
                    catch (IOException e) {
                        log.info("Unable to close JarFile={}", (Object)urlCacheRemoveKey, (Object)e);
                    }
                    if (remove == null) continue;
                    log.trace("Removed item from urlCache={}", remove);
                }
            }
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            log.error("Unable to clear JarFileFactory, you might need to restart Nuxeo", (Throwable)e);
        }
    }

    protected URL toURL(Bundle bundle) {
        String location = bundle.getLocation();
        File file = new File(location);
        return this.toURL(file);
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
    }

    protected void logComponentManagerStatus() {
        log.debug(() -> {
            StringBuilder builder = new StringBuilder("ComponentManager status:\n");
            Framework.getRuntime().getStatusMessage(builder);
            return builder.toString();
        });
    }

    @Override
    public Long lastFlushed() {
        return this.lastFlushed;
    }

    protected void setFlushedNow() {
        this.lastFlushed = System.currentTimeMillis();
    }

    @Override
    @Deprecated(since="5.6")
    public void installWebResources(File file) throws IOException {
        log.info("Install web resources");
        if (file.isDirectory()) {
            File war = new File(file, "web");
            if ((war = new File(war, "nuxeo.war")).isDirectory()) {
                FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
            } else {
                war = new File(file, "nuxeo.war");
                if (war.isDirectory()) {
                    FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
                }
            }
        } else if (file.isFile()) {
            File war = ReloadComponent.getWarDir();
            ZipUtils.unzip((String)"web/nuxeo.war", (File)file, (File)war);
            ZipUtils.unzip((String)"nuxeo.war", (File)file, (File)war);
        }
    }

    @Override
    public void runDeploymentPreprocessor() throws IOException {
        log.info("Start running deployment preprocessor");
        String rootPath = Environment.getDefault().getRuntimeHome().getAbsolutePath();
        File root = new File(rootPath);
        DeploymentPreprocessor processor = new DeploymentPreprocessor(root);
        processor.init();
        processor.predeploy();
        log.info("Deployment preprocessing done");
    }

    protected static File getAppDir() {
        return Environment.getDefault().getConfig().getParentFile();
    }

    protected static File getWarDir() {
        return new File(ReloadComponent.getAppDir(), "nuxeo.war");
    }

    @Override
    public String getOSGIBundleName(File file) {
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf == null) {
            return null;
        }
        String bundleName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bundleName == null) {
            return null;
        }
        int index = bundleName.indexOf(59);
        if (index > -1) {
            bundleName = bundleName.substring(0, index);
        }
        return bundleName;
    }

    @Deprecated(since="9.3")
    protected void triggerReloadWithNewTransaction(String eventId) {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            throw new AssertionError((Object)"The calling transaction is marked rollback");
        }
        boolean hasTransaction = TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (hasTransaction) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        try {
            TransactionHelper.runInTransaction(() -> this.triggerReload(eventId));
        }
        finally {
            if (hasTransaction) {
                TransactionHelper.startTransaction();
            }
        }
    }

    @Deprecated(since="9.3")
    protected void triggerReload(String eventId) {
        log.info("About to send reload event for id: {}", (Object)eventId);
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "before-reload", (Object)this, null));
        try {
            ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", eventId, (Object)this, null));
        }
        finally {
            ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "after-reload", (Object)this, null));
            log.info("Returning from reload for event id: {}", (Object)eventId);
        }
    }
}

