/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk.action.computation;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkBucket;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractBulkComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(AbstractBulkComputation.class);
    protected static final String SELECT_DOCUMENTS_IN = "SELECT * FROM Document, Relation WHERE ecm:uuid IN ('%s')";
    protected Map<String, BulkCommand> commands = new PassiveExpiringMap(60L, TimeUnit.SECONDS);
    protected BulkCommand command;
    protected BulkStatus delta;

    public AbstractBulkComputation(String name) {
        this(name, 1);
    }

    public AbstractBulkComputation(String name, int nbOutputStreams) {
        super(name, 1, nbOutputStreams);
    }

    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        BulkBucket bucket = (BulkBucket)BulkCodecs.getBucketCodec().decode(record.getData());
        this.command = this.getCommand(bucket.getCommandId());
        if (this.command != null) {
            this.delta = BulkStatus.deltaOf(this.command.getId());
            this.delta.setProcessingStartTime(Instant.now());
            this.delta.setProcessed(bucket.getIds().size());
            this.startBucket(record.getKey());
            for (List batch : Lists.partition(bucket.getIds(), (int)this.command.getBatchSize())) {
                this.processBatchOfDocuments(batch);
            }
            this.delta.setProcessingEndTime(Instant.now());
            this.endBucket(context, this.delta);
            context.askForCheckpoint();
        } else if (this.isAbortedCommand(bucket.getCommandId())) {
            log.debug("Skipping aborted command: {}", (Object)bucket.getCommandId());
            context.askForCheckpoint();
        } else {
            throw new IllegalStateException(String.format("Unknown command: %s, offset: %s, record: %s.", bucket.getCommandId(), context.getLastOffset(), record));
        }
    }

    protected boolean isAbortedCommand(String commandId) {
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        BulkStatus status = (BulkStatus)bulkService.getStatus((Serializable)((Object)commandId));
        return BulkStatus.State.ABORTED.equals((Object)status.getState());
    }

    protected BulkCommand getCommand(String commandId) {
        this.commands.size();
        return this.commands.computeIfAbsent(commandId, id -> ((BulkService)Framework.getService(BulkService.class)).getCommand((String)id));
    }

    public BulkCommand getCurrentCommand() {
        return this.command;
    }

    protected void processBatchOfDocuments(List<String> batch) {
        if (batch == null || batch.isEmpty()) {
            return;
        }
        TransactionHelper.runInTransaction(() -> {
            try {
                String username = this.command.getUsername();
                String repository = this.command.getRepository();
                try (NuxeoLoginContext ignored = this.loginSystemOrUser(username);){
                    CoreSession session = repository == null ? null : CoreInstance.getCoreSession((String)repository);
                    this.compute(session, batch, this.command.getParams());
                }
            }
            catch (LoginException e) {
                throw new NuxeoException((Throwable)e);
            }
        });
    }

    protected NuxeoLoginContext loginSystemOrUser(String username) throws LoginException {
        return "system".equals(username) ? Framework.loginSystem() : Framework.loginUser((String)username);
    }

    public void startBucket(String bucketKey) {
    }

    public void endBucket(ComputationContext context, BulkStatus delta) {
        AbstractBulkComputation.updateStatus(context, delta);
    }

    public void processFailure(ComputationContext context, Throwable failure) {
        int status = 500;
        if (failure instanceof NuxeoException) {
            status = ((NuxeoException)failure).getStatusCode();
        }
        log.error(String.format("Action: %s fails on record: %s after retries.", this.metadata.name(), context.getLastOffset()), failure);
        this.delta.inError(this.metadata.name() + " fails on " + context.getLastOffset() + ": " + failure.getMessage(), status);
        this.endBucket(context, this.delta);
    }

    public static void updateStatus(ComputationContext context, BulkStatus delta) {
        context.produceRecord("o1", delta.getId(), BulkCodecs.getStatusCodec().encode((Object)delta));
    }

    protected abstract void compute(CoreSession var1, List<String> var2, Map<String, Serializable> var3);

    public DocumentModelList loadDocuments(CoreSession session, List<String> documentIds) {
        if (documentIds == null || documentIds.isEmpty()) {
            return new DocumentModelListImpl(0);
        }
        return session.query(String.format(SELECT_DOCUMENTS_IN, String.join((CharSequence)"', '", documentIds)));
    }
}

