/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.ecm.webengine.model.impl.ModuleShortcut;

@Path(value="/")
@Produces(value={"text/html; charset=UTF-8"})
@WebObject(type="base")
public class Main
extends ModuleRoot {
    @GET
    public Object doGet() {
        ArrayList<ModuleShortcut> list = new ArrayList<ModuleShortcut>();
        for (ModuleConfiguration mc : this.ctx.getEngine().getModuleManager().getModules()) {
            Path path;
            List items = mc.getShortcuts();
            if (items != null && !items.isEmpty()) {
                for (ModuleShortcut item : items) {
                    if (item.title != null) continue;
                    item.title = mc.name;
                }
                list.addAll(items);
                continue;
            }
            if (mc.isHeadless || mc.roots == null || mc.roots.length <= 0 || (path = mc.roots[0].getAnnotation(Path.class)) == null) continue;
            list.add(new ModuleShortcut(path.value(), mc.name));
        }
        Collections.sort(list, new Comparator<ModuleShortcut>(){

            @Override
            public int compare(ModuleShortcut o1, ModuleShortcut o2) {
                return o1.title.compareTo(o2.title);
            }
        });
        return this.getView("index").arg("moduleLinks", list);
    }

    public Object handleError(Throwable t) {
        if (t instanceof WebSecurityException) {
            return Response.status((int)401).entity((Object)this.getTemplate("error/error_401.ftl")).type("text/html").build();
        }
        if (t instanceof WebResourceNotFoundException) {
            return Response.status((int)404).entity((Object)this.getTemplate("error/error_404.ftl")).type("text/html").build();
        }
        return super.handleError(t);
    }
}

