/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.debug;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XMap;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.OperationChainContribution;
import org.nuxeo.ecm.automation.jaxrs.io.JsonWriter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.webengine.model.Access;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.impl.XMapContext;

@WebObject(type="debug", administrator=Access.GRANT)
public class DebugResource
extends AbstractResource<ResourceTypeImpl> {
    private static final Log log = LogFactory.getLog(DebugResource.class);
    static final XMap xmap = new XMap();
    @Inject
    AutomationService service;
    @Inject
    OperationContext ctx;
    @Inject
    CoreSession session;

    public AutomationService getOperationService() {
        return this.service;
    }

    public String getOperationsListAsJson() throws OperationException, IOException {
        return JsonWriter.exportOperations();
    }

    @GET
    @Produces(value={"text/html"})
    public Object doGet() {
        return this.getView("index");
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/doc")
    public Object doGetText() throws OperationException, IOException {
        return this.getOperationsListAsJson();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/studioDoc")
    public Object doGetStudioDoc() throws OperationException, IOException {
        return JsonWriter.exportOperations((boolean)true);
    }

    @GET
    @Produces(value={"application/json"})
    public Object doGetJSON() throws OperationException, IOException {
        return this.getOperationsListAsJson();
    }

    @POST
    public Response doPost(@FormParam(value="input") String input, @FormParam(value="chain") String chainXml) {
        if (!this.session.getPrincipal().isAdministrator()) {
            return Response.status((int)403).build();
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(chainXml.getBytes());
            OperationChainContribution contrib = (OperationChainContribution)xmap.load((InputStream)in);
            OperationChain chain = contrib.toOperationChain((Context)new XMapContext(Framework.getRuntime().getContext()));
            this.ctx.setInput((Object)this.getDocumentRef(input));
            this.getOperationService().run(this.ctx, chain);
            return Response.ok((Object)"Operation Done.").build();
        }
        catch (IOException | OperationException | NuxeoException e) {
            log.error((Object)e, e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="{chainId}")
    public Response doChainIdPost(@FormParam(value="input") String input, @FormParam(value="chainId") String chainId) {
        try {
            this.ctx.setInput((Object)this.getDocumentRef(input));
            this.getOperationService().run(this.ctx, chainId);
            return Response.ok((Object)"Operation Done.").build();
        }
        catch (OperationException e) {
            log.error((Object)e, (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    protected DocumentRef getDocumentRef(String ref) {
        if (ref == null || ref.length() == 0) {
            return null;
        }
        if (ref.startsWith("/")) {
            return new PathRef(ref);
        }
        return new IdRef(ref);
    }

    static {
        xmap.register(OperationChainContribution.class);
    }
}

