/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryContributor;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Element;

public abstract class AbstractDirectoryDescriptorRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(AbstractDirectoryDescriptorRegistry.class);
    protected static final String DEFAULT_POINT = "directories";
    protected final String componentName;
    protected final String point;

    protected AbstractDirectoryDescriptorRegistry(String componentName) {
        this(componentName, DEFAULT_POINT);
    }

    protected AbstractDirectoryDescriptorRegistry(String componentName, String point) {
        this.componentName = componentName;
        this.point = point;
    }

    protected Registry getTargetRegistry() {
        return (Registry)Framework.getRuntime().getComponentManager().getExtensionPointRegistry("org.nuxeo.ecm.directory.DirectoryServiceImpl", "directoryContributor").orElseThrow(() -> new IllegalArgumentException(String.format("Unknown registry for extension point '%s--%s'", "org.nuxeo.ecm.directory.DirectoryServiceImpl", "directoryContributor")));
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        super.register(ctx, xObject, element, tag);
        this.getTargetRegistry().register(ctx, DirectoryContributor.getXObject(), DirectoryContributor.createElement(element, this.componentName, this.point), tag);
    }

    public void unregister(String tag) {
        super.unregister(tag);
        this.getTargetRegistry().unregister(tag);
    }

    protected String computeId(Context ctx, XAnnotatedObject xObject, Element element) {
        String id = super.computeId(ctx, xObject, element);
        if (id.contains("/") && log.isWarnEnabled()) {
            log.warn("Directory {} should not contain forward slashes in its name, as they are not supported. Operations with the REST API on this directory won't work.", (Object)id);
        }
        return id;
    }

    protected <T> T getMergedInstance(Context ctx, XAnnotatedObject xObject, Element element, Object existing) {
        BaseDirectoryDescriptor contrib = (BaseDirectoryDescriptor)this.getInstance(ctx, xObject, element);
        if (existing != null) {
            ((BaseDirectoryDescriptor)existing).merge(contrib);
            return (T)existing;
        }
        return (T)contrib;
    }
}

