/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.core.CoreDirectory;
import org.nuxeo.runtime.api.Framework;

@XObject(value="directory")
@XRegistry
public class CoreDirectoryDescriptor
extends BaseDirectoryDescriptor {
    protected static final Log log = LogFactory.getLog(CoreDirectoryDescriptor.class);
    public static final String DEFAULT_CREATE_PATH = "/";
    public static final boolean DEFAULT_CAN_CREATE_ROOT_FOLDER = true;
    @XNode(value="docType")
    protected String docType;
    @XNode(value="querySizeLimit")
    public Integer querySizeLimit;
    @XNode(value="repositoryName")
    protected String repositoryName;
    @XNode(value="createPath")
    protected String createPath;
    @XNode(value="canCreateRootFolder")
    protected Boolean canCreateRootFolder;
    @XNodeMap(value="fieldMapping", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> fieldMapping = new HashMap<String, String>();
    @XNodeList(value="acl", type=ACLDescriptor[].class, componentType=ACLDescriptor.class)
    protected ACLDescriptor[] acls;

    public String getCreatePath() {
        return this.createPath == null ? DEFAULT_CREATE_PATH : this.createPath;
    }

    public boolean canCreateRootFolder() {
        return this.canCreateRootFolder == null ? true : this.canCreateRootFolder;
    }

    public CoreDirectoryDescriptor clone() {
        CoreDirectoryDescriptor clone = (CoreDirectoryDescriptor)super.clone();
        clone.fieldMapping = this.fieldMapping;
        if (this.acls != null) {
            clone.acls = (ACLDescriptor[])this.acls.clone();
        }
        return clone;
    }

    public String getRepositoryName() {
        if (StringUtils.isBlank((CharSequence)this.repositoryName)) {
            this.repositoryName = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
        }
        return this.repositoryName;
    }

    public void merge(BaseDirectoryDescriptor other) {
        super.merge(other);
        if (other instanceof CoreDirectoryDescriptor) {
            this.merge((CoreDirectoryDescriptor)other);
        }
    }

    protected void merge(CoreDirectoryDescriptor other) {
        if (other.docType != null) {
            this.docType = other.docType;
        }
        if (other.querySizeLimit != null) {
            this.querySizeLimit = other.querySizeLimit;
        }
        if (other.repositoryName != null) {
            this.repositoryName = other.repositoryName;
        }
        if (other.createPath != null) {
            this.createPath = other.createPath;
        }
        if (other.docType != null) {
            this.docType = other.docType;
        }
        if (other.fieldMapping != null) {
            this.fieldMapping = other.fieldMapping;
        }
        if (other.canCreateRootFolder != null) {
            this.canCreateRootFolder = other.canCreateRootFolder;
        }
        if (other.acls != null) {
            ACLDescriptor[] otherAcls = new ACLDescriptor[this.acls.length + other.acls.length];
            System.arraycopy(this.acls, 0, otherAcls, 0, this.acls.length);
            System.arraycopy(other.acls, 0, otherAcls, this.acls.length, other.acls.length);
            this.acls = otherAcls;
        }
    }

    public CoreDirectory newDirectory() {
        return new CoreDirectory(this);
    }

    @XObject(value="acl")
    public static class ACLDescriptor
    implements Cloneable {
        @XNode(value="@userOrGroupName")
        public String userOrGroupName;
        @XNode(value="@privilege")
        public String privilege;
        @XNode(value="@granted")
        public boolean granted = false;

        public ACLDescriptor clone() {
            ACLDescriptor clone;
            try {
                clone = (ACLDescriptor)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
            return clone;
        }
    }
}

