/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.factory;

import java.util.Properties;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.support.ConfigConstants;
import ro.isdc.wro.util.ObjectFactory;

public class PropertyWroConfigurationFactory
implements ObjectFactory<WroConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyWroConfigurationFactory.class);
    private final Properties properties;

    public PropertyWroConfigurationFactory() {
        this(new Properties());
    }

    public PropertyWroConfigurationFactory(Properties props) {
        Validate.notNull((Object)props);
        this.properties = props;
    }

    @Override
    public WroConfiguration create() {
        WroConfiguration config = new WroConfiguration();
        config.setCacheGzippedContent(this.valueAsBoolean(ConfigConstants.cacheGzippedContent));
        config.setCacheHttpEnabled(this.valueAsBoolean(ConfigConstants.cacheHttpEnabled));
        config.setCacheUpdatePeriod(this.valueAsLong(ConfigConstants.cacheUpdatePeriod));
        config.setConnectionTimeout(this.valueAsInteger(ConfigConstants.connectionTimeout));
        config.setDebug(this.valueAsBoolean(ConfigConstants.debug));
        config.setEncoding(this.valueAsString(ConfigConstants.encoding));
        config.setGzipEnabled(this.valueAsBoolean(ConfigConstants.gzipResources));
        config.setHeader(this.valueAsString(ConfigConstants.header));
        config.setIgnoreEmptyGroup(this.valueAsBoolean(ConfigConstants.ignoreEmptyGroup));
        config.setIgnoreFailingProcessor(this.valueAsBoolean(ConfigConstants.ignoreFailingProcessor));
        config.setIgnoreMissingResources(this.valueAsBoolean(ConfigConstants.ignoreMissingResources));
        config.setJmxEnabled(this.valueAsBoolean(ConfigConstants.jmxEnabled));
        config.setMbeanName(this.valueAsString(ConfigConstants.mbeanName));
        config.setMinimizeEnabled(this.valueAsBoolean(ConfigConstants.minimizeEnabled));
        config.setModelUpdatePeriod(this.valueAsLong(ConfigConstants.modelUpdatePeriod));
        config.setParallelPreprocessing(this.valueAsBoolean(ConfigConstants.parallelPreprocessing));
        config.setResourceWatcherAsync(this.valueAsBoolean(ConfigConstants.resourceWatcherAsync));
        config.setResourceWatcherUpdatePeriod(this.valueAsLong(ConfigConstants.resourceWatcherUpdatePeriod));
        config.setWroManagerClassName(this.valueAsString(ConfigConstants.managerFactoryClassName));
        LOG.debug("WroConfiguration created: {}", (Object)config);
        return config;
    }

    private Integer valueAsInteger(ConfigConstants configuration) {
        String stringValue = this.valueAsString(configuration);
        if (stringValue == null) {
            return null;
        }
        try {
            return Integer.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            String message = "Invalid Integer value: " + stringValue;
            LOG.error(message);
            throw new WroRuntimeException(message);
        }
    }

    private Long valueAsLong(ConfigConstants configuration) {
        String stringValue = this.valueAsString(configuration);
        if (stringValue == null) {
            return null;
        }
        try {
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            String message = "Invalid Long value: " + stringValue;
            LOG.error(message);
            throw new WroRuntimeException(message);
        }
    }

    private Boolean valueAsBoolean(ConfigConstants configuration) {
        return BooleanUtils.toBooleanObject((String)this.valueAsString(configuration));
    }

    private String valueAsString(ConfigConstants configuration) {
        Object propertyValue;
        if (configuration != null && (propertyValue = this.properties.get(configuration.getPropertyKey())) != null) {
            return StringUtils.trimToNull((String)String.valueOf(propertyValue));
        }
        return null;
    }
}

