/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.http.handler.RequestHandlerSupport;
import ro.isdc.wro.http.support.ContentTypeResolver;
import ro.isdc.wro.http.support.HttpHeader;
import ro.isdc.wro.http.support.ResponseHeadersConfigurer;
import ro.isdc.wro.http.support.UnauthorizedRequestException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;

public class ResourceProxyRequestHandler
extends RequestHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceProxyRequestHandler.class);
    public static final String PARAM_RESOURCE_ID = "id";
    public static final String PATH_RESOURCES = "wroResources";
    public static final String ALIAS = "resourceProxy";
    @Inject
    private UriLocatorFactory locatorFactory;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private ResourceAuthorizationManager authManager;
    private ResponseHeadersConfigurer headersConfigurer;

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.verifyAccess(request, response);
        this.serveProxyResourceUri(request, response);
    }

    @Override
    public boolean accept(HttpServletRequest request) {
        return this.isProxyRequest(request);
    }

    private void serveProxyResourceUri(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block12: {
            String resourceUri = this.getResourceUri(request);
            LOG.debug("[OK] serving proxy resource: {}", (Object)resourceUri);
            ServletOutputStream outputStream = response.getOutputStream();
            response.setContentType(ContentTypeResolver.get(resourceUri, this.context.getConfig().getEncoding()));
            if (this.isResourceChanged(request)) {
                this.getHeadersConfigurer().setHeaders(response);
                try (AutoCloseInputStream is = new AutoCloseInputStream(this.locatorFactory.locate(resourceUri));
                     ServletOutputStream servletOutputStream = outputStream;){
                    int length = IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                    response.setContentLength(length);
                    response.setStatus(200);
                    break block12;
                }
            }
            response.setStatus(304);
        }
    }

    protected boolean isResourceChanged(HttpServletRequest request) {
        try {
            long ifModifiedSince = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString());
            return ifModifiedSince < this.getHeadersConfigurer().getLastModifiedTimestamp();
        }
        catch (Exception e) {
            LOG.warn("Could not extract IF_MODIFIED_SINCE header for request: " + request.getRequestURI() + ". Assuming content is changed. ", (Throwable)e);
            return true;
        }
    }

    private void verifyAccess(HttpServletRequest request, HttpServletResponse response) {
        String resourceUri = this.getResourceUri(request);
        if (!this.authManager.isAuthorized(resourceUri)) {
            LOG.debug("[FAIL] Unauthorized proxy resource: {}", (Object)resourceUri);
            response.setStatus(403);
            throw new UnauthorizedRequestException("Unauthorized resource request detected: " + resourceUri);
        }
    }

    private String getResourceUri(HttpServletRequest request) {
        return request.getParameter(PARAM_RESOURCE_ID);
    }

    private final ResponseHeadersConfigurer getHeadersConfigurer() {
        if (this.headersConfigurer == null) {
            this.headersConfigurer = this.newResponseHeadersConfigurer();
        }
        return this.headersConfigurer;
    }

    protected ResponseHeadersConfigurer newResponseHeadersConfigurer() {
        return ResponseHeadersConfigurer.fromConfig(this.context.getConfig());
    }

    public static String createProxyPath(String requestUri, String resourceId) {
        Validate.notNull((Object)requestUri);
        Validate.notNull((Object)resourceId);
        return requestUri + ResourceProxyRequestHandler.getRequestHandlerPath(resourceId);
    }

    public static boolean isProxyUri(String url) {
        Validate.notNull((Object)url);
        return url.contains(ResourceProxyRequestHandler.getRequestHandlerPath());
    }

    private boolean isProxyRequest(HttpServletRequest request) {
        String apiHandlerValue = request.getParameter("wroAPI");
        String resourceId = request.getParameter(PARAM_RESOURCE_ID);
        return PATH_RESOURCES.equals(apiHandlerValue) && resourceId != null;
    }

    private static String getRequestHandlerPath() {
        return String.format("?%s=%s", "wroAPI", PATH_RESOURCES);
    }

    private static String getRequestHandlerPath(String resourceId) {
        return String.format("%s&%s=%s", ResourceProxyRequestHandler.getRequestHandlerPath(), PARAM_RESOURCE_ID, resourceId);
    }
}

