/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.factory;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Inject;

public abstract class AbstractWroModelFactory
implements WroModelFactory {
    @Inject
    private ReadOnlyContext context;

    protected InputStream getModelResourceAsStream() throws IOException {
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            throw new WroRuntimeException("No servletContext is available. Probably you are running this code outside of the request cycle!");
        }
        String resourceLocation = "/WEB-INF/" + this.getDefaultModelFilename();
        InputStream stream = servletContext.getResourceAsStream(resourceLocation);
        if (stream == null) {
            throw new IOException("Invalid resource requested: " + resourceLocation);
        }
        return stream;
    }

    protected abstract String getDefaultModelFilename();

    @Override
    public void destroy() {
    }
}

