/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.change;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.support.ContextPropagatingCallable;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.http.handler.ResourceWatcherRequestHandler;
import ro.isdc.wro.http.support.PreserveDetailsRequestWrapper;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.support.change.ResourceChangeDetector;
import ro.isdc.wro.util.DestroyableLazyInitializer;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class ResourceWatcher
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceWatcher.class);
    private static final int POOL_SIZE = Runtime.getRuntime().availableProcessors();
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private UriLocatorFactory locatorFactory;
    @Inject
    private Injector injector;
    @Inject
    private LifecycleCallbackRegistry lifecycleCallback;
    @Inject
    private ResourceChangeDetector resourceChangeDetector;
    @Inject
    private CacheStrategy<CacheKey, CacheValue> cacheStrategy;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private DispatcherStreamLocator dispatcherLocator;
    private final DestroyableLazyInitializer<ExecutorService> executorServiceRef = new DestroyableLazyInitializer<ExecutorService>(){

        @Override
        protected ExecutorService initialize() {
            return Executors.newFixedThreadPool(POOL_SIZE, WroUtil.createDaemonThreadFactory(ResourceWatcher.class.getName()));
        }

        @Override
        public void destroy() {
            if (this.isInitialized()) {
                ((ExecutorService)this.get()).shutdownNow();
            }
            super.destroy();
        }
    };

    public void check(CacheKey cacheKey) {
        this.check(cacheKey, new CallbackSupport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(CacheKey cacheKey, Callback callback) {
        Validate.notNull((Object)cacheKey);
        LOG.debug("started");
        StopWatch watch = new StopWatch();
        watch.start("detect changes");
        try {
            Group group = new WroModelInspector((WroModel)this.modelFactory.create()).getGroupByName(cacheKey.getGroupName());
            if (this.isGroupChanged(group.collectResourcesOfType(cacheKey.getType()), callback)) {
                callback.onGroupChanged(cacheKey);
                this.cacheStrategy.put(cacheKey, null);
            }
            this.resourceChangeDetector.reset();
        }
        catch (Exception e) {
            this.onException(e);
        }
        finally {
            watch.stop();
            LOG.debug("resource watcher info: {}", (Object)watch.prettyPrint());
        }
    }

    public boolean tryAsyncCheck(CacheKey cacheKey) {
        boolean checkInvoked = false;
        if (this.context.getConfig().isResourceWatcherAsync()) {
            if (this.isAsyncCheckAllowed()) {
                LOG.debug("Checking resourceWatcher asynchronously...");
                Callable<Void> callable = this.createAsyncCheckCallable(cacheKey);
                this.submit(callable);
                checkInvoked = true;
            }
        } else {
            LOG.debug("Async check not allowed. Falling back to sync check.");
            this.check(cacheKey);
            checkInvoked = true;
        }
        return checkInvoked;
    }

    private boolean isAsyncCheckAllowed() {
        return WroFilter.isPassedThroughyWroFilter(Context.get().getRequest());
    }

    void submit(Callable<Void> callable) {
        ((ExecutorService)this.executorServiceRef.get()).submit(callable);
    }

    protected void onException(Exception e) {
        LOG.info("Could not check for resource changes because: {}", (Object)e.getMessage());
        LOG.debug("[FAIL] detecting resource change ", (Throwable)e);
    }

    private boolean isGroupChanged(final Group group, final Callback callback) {
        List<Resource> resources = group.getResources();
        final AtomicBoolean isChanged = new AtomicBoolean(false);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        boolean isAsync = this.context.getConfig().isResourceWatcherAsync();
        try {
            for (final Resource resource : resources) {
                if (isAsync) {
                    futures.add(((ExecutorService)this.executorServiceRef.get()).submit(ContextPropagatingCallable.decorate(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            ResourceWatcher.this.checkResourceChange(resource, group, callback, isChanged);
                            return null;
                        }
                    })));
                    continue;
                }
                this.checkResourceChange(resource, group, callback, isChanged);
            }
            if (isAsync) {
                LOG.debug("await async execution");
                for (Future future : futures) {
                    future.get();
                }
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while onResourceChange is invoked", (Throwable)e);
        }
        LOG.debug("group={}, changed={}", (Object)group.getName(), (Object)isChanged);
        return isChanged.get();
    }

    private void checkResourceChange(Resource resource, Group group, Callback callback, AtomicBoolean isChanged) throws Exception {
        if (this.isChanged(resource, group.getName())) {
            isChanged.compareAndSet(false, true);
            callback.onResourceChanged(resource);
            this.lifecycleCallback.onResourceChanged(resource);
        }
    }

    private boolean isChanged(Resource resource, String groupName) {
        boolean changed = false;
        try {
            String uri = resource.getUri();
            AtomicBoolean changeDetected = new AtomicBoolean(this.resourceChangeDetector.checkChangeForGroup(uri, groupName));
            if (!changeDetected.get() && resource.getType() == ResourceType.CSS) {
                InputStreamReader reader = new InputStreamReader(this.locatorFactory.locate(uri), Charset.defaultCharset());
                LOG.debug("\tCheck @import directive from {}", (Object)resource);
                this.createCssImportProcessor(changeDetected, groupName).process(resource, reader, new StringWriter());
            }
            changed = changeDetected.get();
        }
        catch (IOException e) {
            LOG.debug("[FAIL] Cannot check {} resource (Exception message: {}). Assuming it is unchanged...", (Object)resource, (Object)e.getMessage());
        }
        LOG.debug("resource={}, changed={}", (Object)resource.getUri(), (Object)changed);
        return changed;
    }

    private ResourcePreProcessor createCssImportProcessor(final AtomicBoolean changeDetected, final String groupName) {
        AbstractCssImportPreProcessor cssImportProcessor = new AbstractCssImportPreProcessor(){

            @Override
            protected void onImportDetected(String importedUri) {
                LOG.debug("Found @import {}", (Object)importedUri);
                boolean isImportChanged = ResourceWatcher.this.isChanged(Resource.create(importedUri, ResourceType.CSS), groupName);
                LOG.debug("\tisImportChanged={}", (Object)isImportChanged);
                if (isImportChanged) {
                    changeDetected.set(true);
                }
            }

            @Override
            protected String doTransform(String cssContent, List<Resource> foundImports) throws IOException {
                return "";
            }

            public String toString() {
                return CssImportPreProcessor.class.getSimpleName();
            }
        };
        ExceptionHandlingProcessorDecorator processor = new ExceptionHandlingProcessorDecorator(cssImportProcessor){

            @Override
            protected boolean isIgnoreFailingProcessor() {
                return true;
            }
        };
        this.injector.inject(processor);
        return processor;
    }

    private Callable<Void> createAsyncCheckCallable(final CacheKey cacheKey) {
        HttpServletRequest originalRequest = Context.get().getRequest();
        LOG.debug("OriginalRequest: url={}, uri={}, servletPath={}", new Object[]{originalRequest.getRequestURL(), originalRequest.getRequestURI(), originalRequest.getServletPath()});
        PreserveDetailsRequestWrapper request = new PreserveDetailsRequestWrapper(originalRequest);
        return ContextPropagatingCallable.decorate(new Callable<Void>((HttpServletRequest)request){
            final /* synthetic */ HttpServletRequest val$request;
            {
                this.val$request = httpServletRequest;
            }

            @Override
            public Void call() throws Exception {
                String location = ResourceWatcherRequestHandler.createHandlerRequestPath(cacheKey, this.val$request);
                try {
                    ResourceWatcher.this.dispatcherLocator.locateExternal(this.val$request, location);
                    return null;
                }
                catch (IOException e) {
                    StringBuilder message = new StringBuilder("Could not check the following cacheKey: ").append(cacheKey);
                    if (e instanceof SocketTimeoutException) {
                        message.append(". The invocation of ").append(location).append(" timed out. Consider increasing the connectionTimeout configuration.");
                        LOG.error(message.toString());
                    } else {
                        LOG.error(message.toString(), (Throwable)e);
                    }
                    throw e;
                }
            }
        });
    }

    ResourceChangeDetector getResourceChangeDetector() {
        return this.resourceChangeDetector;
    }

    @Override
    public void destroy() throws Exception {
        this.executorServiceRef.destroy();
    }

    public static class CallbackSupport
    implements Callback {
        @Override
        public void onGroupChanged(CacheKey key) {
        }

        @Override
        public void onResourceChanged(Resource resource) {
        }
    }

    public static interface Callback {
        public void onGroupChanged(CacheKey var1);

        public void onResourceChanged(Resource var1);
    }
}

