/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.json.JSONException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.elasticsearch.http.readonly.filter.RequestValidator;
import org.nuxeo.elasticsearch.http.readonly.filter.SearchRequestFilter;

public abstract class AbstractSearchRequestFilterImpl
implements SearchRequestFilter {
    protected static final String MATCH_ALL = "{\"query\": {\"match_all\": {}}}";
    protected static final String QUERY_STRING = "{\"query\":{\"query_string\":{\"query\":\"%s\",\"default_field\":\"%s\",\"default_operator\":\"%s\"}}}";
    protected static final String BACKSLASH_MARKER = "_@@_";
    protected String payload;
    protected String rawQuery;
    @Deprecated(since="11.4", forRemoval=true)
    protected String types;
    protected String indices;
    protected NuxeoPrincipal principal;
    protected String url;
    protected String filteredPayload;

    @Override
    public void init(CoreSession session, String indices, String rawQuery, String payload) {
        RequestValidator validator = new RequestValidator();
        this.indices = validator.getIndices(indices);
        this.principal = session.getPrincipal();
        this.rawQuery = rawQuery;
        this.payload = payload;
        if (payload == null && !this.principal.isAdministrator()) {
            this.extractPayloadFromQuery();
        }
    }

    @Override
    public String getTypes() {
        return this.types;
    }

    @Override
    public String getIndices() {
        return this.indices;
    }

    public String toString() {
        if (this.payload == null || this.payload.isEmpty()) {
            return "Uri Search: " + this.getUrl() + " user: " + this.principal;
        }
        try {
            return "Body Search: " + this.getUrl() + " user: " + this.principal + " payload: " + this.getPayload();
        }
        catch (JSONException e) {
            return "Body Search: " + this.getUrl() + " user: " + this.principal + " invalid JSON payload: " + e.getMessage();
        }
    }

    @Override
    @NotNull
    public String getUrl() {
        if (this.url == null) {
            this.url = "/" + this.indices + "/_search";
            if (this.rawQuery != null) {
                this.url = this.url + "?" + this.rawQuery;
            }
        }
        return this.url;
    }

    @Override
    public abstract String getPayload() throws JSONException;

    protected Map<String, String> getQueryMap() {
        String[] params = this.rawQuery.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            if (param.contains("=")) {
                map.put(name, param.split("=")[1]);
                continue;
            }
            map.put(name, "");
        }
        return map;
    }

    protected void setRawQuery(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            if (entry.getValue().isEmpty()) {
                sb.append(entry.getKey());
                continue;
            }
            sb.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        this.rawQuery = sb.toString();
    }

    protected void extractPayloadFromQuery() {
        String defaultOperator;
        Map<String, String> qm = this.getQueryMap();
        String queryString = qm.remove("q");
        if (queryString == null) {
            this.payload = MATCH_ALL;
            return;
        }
        try {
            queryString = URLDecoder.decode(queryString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid URI Search query_string encoding: " + e.getMessage());
        }
        String defaultField = qm.remove("df");
        if (defaultField == null) {
            defaultField = "_all";
        }
        if ((defaultOperator = qm.remove("default_operator")) == null) {
            defaultOperator = "OR";
        }
        this.payload = String.format(QUERY_STRING, queryString, defaultField, defaultOperator);
        this.setRawQuery(qm);
    }
}

