/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.http.readonly;

import java.io.IOException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.json.JSONException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.client.ESRestClient;
import org.nuxeo.elasticsearch.http.readonly.DocRequestFilter;
import org.nuxeo.elasticsearch.http.readonly.filter.DefaultSearchRequestFilter;
import org.nuxeo.elasticsearch.http.readonly.filter.RequestValidator;
import org.nuxeo.elasticsearch.http.readonly.filter.SearchRequestFilter;
import org.nuxeo.elasticsearch.http.readonly.service.RequestFilterService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/es")
@WebObject(type="es")
public class Main
extends ModuleRoot {
    private static final Logger log = LogManager.getLogger(Main.class);
    private static final String DEFAULT_ES_BASE_URL = "http://localhost:9200/";
    private static final String ES_BASE_URL_PROPERTY = "elasticsearch.httpReadOnly.baseUrl";
    private String esBaseUrl;

    public Main() {
        if (this.getContext() == null) {
            // empty if block
        }
        log.debug("New instance of ES module");
    }

    @GET
    @Path(value="_search")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String searchWithPayload(@Context UriInfo uriInf, MultivaluedMap<String, String> formParams) throws IOException, JSONException {
        return this.doSearchWithPayload("_all", uriInf.getRequestUri().getRawQuery(), (String)formParams.keySet().iterator().next());
    }

    @POST
    @Path(value="_search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String searchWithPost(@Context UriInfo uriInf, String payload) throws IOException, JSONException {
        return this.doSearchWithPayload("_all", uriInf.getRequestUri().getRawQuery(), payload);
    }

    @GET
    @Path(value="{indices}/_search")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String searchWithPayload(@PathParam(value="indices") String indices, @Context UriInfo uriInf, MultivaluedMap<String, String> formParams) throws IOException, JSONException {
        return this.doSearchWithPayload(indices, uriInf.getRequestUri().getRawQuery(), (String)formParams.keySet().iterator().next());
    }

    @POST
    @Path(value="{indices}/_search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String searchWithPost(@PathParam(value="indices") String indices, @Context UriInfo uriInf, String payload) throws IOException, JSONException {
        return this.doSearchWithPayload(indices, uriInf.getRequestUri().getRawQuery(), payload);
    }

    @GET
    @Path(value="{indices}/{types}/_search")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Deprecated(since="11.4", forRemoval=true)
    public String searchWithPayload(@PathParam(value="indices") String indices, @PathParam(value="types") String types, @Context UriInfo uriInf, MultivaluedMap<String, String> formParams) throws IOException, JSONException {
        return this.doSearchWithPayload(indices, types, uriInf.getRequestUri().getRawQuery(), (String)formParams.keySet().iterator().next());
    }

    @POST
    @Path(value="{indices}/{types}/_search")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated(since="11.4", forRemoval=true)
    public String searchWithPost(@PathParam(value="indices") String indices, @PathParam(value="types") String types, @Context UriInfo uriInf, String payload) throws IOException, JSONException {
        return this.doSearchWithPayload(indices, types, uriInf.getRequestUri().getRawQuery(), payload);
    }

    @Deprecated(since="11.4", forRemoval=true)
    protected String doSearchWithPayload(String indices, String types, String rawQuery, String payload) throws IOException, JSONException {
        log.warn("Specifying types in search requests is deprecated.");
        return this.doSearchWithPayload(indices, rawQuery, payload);
    }

    protected String doSearchWithPayload(String indices, String rawQuery, String payload) throws IOException, JSONException {
        RequestFilterService requestFilterService = (RequestFilterService)((Object)Framework.getService(RequestFilterService.class));
        try {
            SearchRequestFilter req = requestFilterService.getRequestFilters(indices);
            if (req == null) {
                req = new DefaultSearchRequestFilter();
            }
            req.init(this.getContext().getCoreSession(), indices, rawQuery, payload);
            log.debug((Object)req);
            return this.getWithRestClient(req.getUrl(), req.getPayload());
        }
        catch (ReflectiveOperationException e) {
            log.error("Error when trying to get Search Request Filter for indice {}", (Object)indices, (Object)e);
            return null;
        }
    }

    @GET
    @Path(value="{indices}/_search")
    @Produces(value={"application/json"})
    public String searchWithUri(@PathParam(value="indices") String indices, @Context UriInfo uriInf) throws IOException, JSONException {
        DefaultSearchRequestFilter req = new DefaultSearchRequestFilter();
        req.init(this.getContext().getCoreSession(), indices, uriInf.getRequestUri().getRawQuery(), null);
        log.debug((Object)req);
        return this.getWithRestClient(req.getUrl(), req.getPayload());
    }

    @GET
    @Path(value="{indices}/{types}/_search")
    @Produces(value={"application/json"})
    @Deprecated(since="11.4", forRemoval=true)
    public String searchWithUri(@PathParam(value="indices") String indices, @PathParam(value="types") String types, @Context UriInfo uriInf) throws IOException, JSONException {
        log.warn("Specifying types in search requests is deprecated.");
        return this.searchWithUri(indices, uriInf);
    }

    @GET
    @Path(value="{indices}/{documentId: [a-zA-Z0-9\\-]+}")
    @Produces(value={"application/json"})
    public String getDocument(@PathParam(value="indices") String indices, @PathParam(value="documentId") String documentId, @Context UriInfo uriInf) throws IOException, JSONException {
        NuxeoPrincipal principal = this.getPrincipal();
        RequestValidator validator = new RequestValidator();
        indices = validator.getIndices(indices);
        validator.checkValidDocumentId(documentId);
        DocRequestFilter req = new DocRequestFilter(principal, indices, documentId, uriInf.getRequestUri().getRawQuery());
        log.debug((Object)req);
        if (!principal.isAdministrator()) {
            String docAcl = this.getWithRestClient(req.getCheckAccessUrl());
            validator.checkAccess(principal, docAcl);
        }
        return this.getWithRestClient(req.getUrl());
    }

    @GET
    @Path(value="{indices}/{types}/{documentId: [a-zA-Z0-9\\-]+}")
    @Produces(value={"application/json"})
    @Deprecated(since="11.4", forRemoval=true)
    public String getDocument(@PathParam(value="indices") String indices, @PathParam(value="types") String types, @PathParam(value="documentId") String documentId, @Context UriInfo uriInf) throws IOException, JSONException {
        log.warn("Specifying types in get document is deprecated.");
        return this.getDocument(indices, documentId, uriInf);
    }

    protected String getElasticsearchBaseUrl() {
        if (this.esBaseUrl == null) {
            this.esBaseUrl = Framework.getProperty((String)ES_BASE_URL_PROPERTY, (String)DEFAULT_ES_BASE_URL);
        }
        return this.esBaseUrl;
    }

    @NotNull
    public NuxeoPrincipal getPrincipal() {
        NuxeoPrincipal principal = this.ctx.getPrincipal();
        if (principal == null) {
            throw new IllegalArgumentException("No principal found");
        }
        return principal;
    }

    protected String getWithRestClient(String endpoint) {
        return this.getWithRestClient(endpoint, null);
    }

    protected String getWithRestClient(String endpoint, String payload) {
        ESClient esClient = ((ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class)).getClient();
        if (!(esClient instanceof ESRestClient)) {
            throw new IllegalStateException("Passthrough works only with a RestClient");
        }
        ESRestClient client = (ESRestClient)esClient;
        Request request = new Request("GET", endpoint);
        if (payload != null) {
            request.setJsonEntity(payload);
        }
        Response response = client.performRequestWithTracing(request);
        try {
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot parse response: " + response, (Throwable)e);
        }
    }
}

