/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Reference;

public class Expression
implements Operand {
    private static final long serialVersionUID = 6007989243273673300L;
    public final Operator operator;
    public final Operand lvalue;
    public final Operand rvalue;
    public Object info;

    public Expression(Operand lvalue, Operator operator, Operand rvalue) {
        this.lvalue = lvalue;
        this.rvalue = rvalue;
        this.operator = operator;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitExpression(this);
    }

    public boolean isSuffix() {
        return this.operator == Operator.ISNULL || this.operator == Operator.ISNOTNULL;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public Object getInfo() {
        return this.info;
    }

    public String toString() {
        if (this.rvalue == null) {
            if (this.isSuffix()) {
                return this.lvalue.toString() + " " + this.operator.toString();
            }
            return this.operator.toString() + " " + this.lvalue.toString();
        }
        return "(" + this.lvalue.toString() + " " + this.operator.toString() + " " + this.rvalue.toString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Expression) {
            Expression e = (Expression)obj;
            if (this.operator.id != e.operator.id) {
                return false;
            }
            if (!this.lvalue.equals(e.lvalue)) {
                return false;
            }
            return !(this.rvalue != null ? !this.rvalue.equals(e.rvalue) : e.rvalue != null);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.operator.hashCode();
        result = 37 * result + (this.lvalue == null ? 0 : this.lvalue.hashCode());
        result = 37 * result + (this.rvalue == null ? 0 : this.rvalue.hashCode());
        return result;
    }

    public boolean isPathExpression() {
        return this.lvalue instanceof Reference && "ecm:path".equals(((Reference)this.lvalue).name);
    }
}

