/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.BlobWrapper;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingConfigurationDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageResizer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ImagingComponent
extends DefaultComponent
implements ImagingService {
    private static final Logger log = LogManager.getLogger(ImagingComponent.class);
    public static final String CONFIGURATION_PARAMETERS_EP = "configuration";
    public static final String PICTURE_CONVERSIONS_EP = "pictureConversions";
    protected Map<String, String> configurationParameters;
    protected List<PictureConversion> conversions;

    public void start(ComponentContext context) {
        this.configurationParameters = this.getRegistryContribution(CONFIGURATION_PARAMETERS_EP).map(ImagingConfigurationDescriptor::getParameters).orElse(new HashMap());
        this.conversions = new ArrayList<PictureConversion>(this.getRegistryContributions(PICTURE_CONVERSIONS_EP));
        Collections.sort(this.conversions);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.configurationParameters = null;
        this.conversions = null;
    }

    @Override
    public List<PictureConversion> getPictureConversions() {
        return Collections.unmodifiableList(this.conversions);
    }

    @Override
    public PictureConversion getPictureConversion(String id) {
        if (id == null) {
            return null;
        }
        return this.getRegistryContribution(PICTURE_CONVERSIONS_EP, id).orElse(null);
    }

    @Override
    public Blob crop(Blob blob, int x, int y, int width, int height) {
        return this.getLibrarySelectorService().getImageUtils().crop(blob, x, y, width, height);
    }

    @Override
    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        return this.getLibrarySelectorService().getImageUtils().resize(blob, finalFormat, width, height, depth);
    }

    @Override
    public Blob rotate(Blob blob, int angle) {
        return this.getLibrarySelectorService().getImageUtils().rotate(blob, angle);
    }

    @Override
    public Blob convertToPDF(Blob blob) {
        return this.getLibrarySelectorService().getImageUtils().convertToPDF(blob);
    }

    @Override
    public Map<String, Object> getImageMetadata(Blob blob) {
        log.warn("org.nuxeo.ecm.platform.picture.ImagingComponent.getImageMetadata is deprecated. Please use org.nuxeo.binary.metadata.api.BinaryMetadataService#readMetadata(org.nuxeo.ecm.core.api.Blob)");
        return Collections.emptyMap();
    }

    @Override
    public String getImageMimeType(File file) {
        try {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            return mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(file.getName(), Blobs.createBlob((File)file), "image/jpeg");
        }
        catch (IOException | MimetypeDetectionException | MimetypeNotFoundException e) {
            log.error("Unable to retrieve mime type", e);
            return null;
        }
    }

    @Override
    public String getImageMimeType(Blob blob) {
        try {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            if (blob.getFilename() != null) {
                return mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "image/jpeg");
            }
            return mimetypeRegistry.getMimetypeFromBlob(blob);
        }
        catch (MimetypeDetectionException | MimetypeNotFoundException e) {
            log.error("Unable to retrieve mime type", e);
            return null;
        }
    }

    private LibrarySelector getLibrarySelectorService() {
        LibrarySelector librarySelector = (LibrarySelector)Framework.getService(LibrarySelector.class);
        if (librarySelector == null) {
            log.error("Unable to get LibrarySelector runtime service");
            throw new NuxeoException("Unable to get LibrarySelector runtime service");
        }
        return librarySelector;
    }

    @Override
    public ImageInfo getImageInfo(Blob blob) {
        ImageInfo imageInfo = null;
        try {
            String ext = blob.getFilename() == null ? ".tmp" : "." + FilenameUtils.getExtension((String)blob.getFilename());
            try (CloseableFile cf = blob.getCloseableFile(ext);){
                imageInfo = ImageIdentifier.getInfo(cf.getFile().getAbsolutePath());
            }
        }
        catch (IOException | CommandException | CommandNotAvailable e) {
            log.error("Failed to get ImageInfo for file {}", (Object)blob.getFilename(), (Object)e);
        }
        return imageInfo;
    }

    @Override
    public String getConfigurationValue(String configurationName) {
        return this.configurationParameters.get(configurationName);
    }

    @Override
    public String getConfigurationValue(String configurationName, String defaultValue) {
        return this.configurationParameters.getOrDefault(configurationName, defaultValue);
    }

    @Override
    public void setConfigurationValue(String configurationName, String configurationValue) {
        this.configurationParameters.put(configurationName, configurationValue);
    }

    @Override
    public PictureView computeViewFor(Blob blob, PictureConversion pictureConversion, boolean convert) {
        return this.computeViewFor(blob, pictureConversion, null, convert);
    }

    @Override
    public PictureView computeViewFor(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, boolean convert) {
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            blob.setMimeType(this.getImageMimeType(blob));
        }
        if (imageInfo == null) {
            imageInfo = this.getImageInfo(blob);
        }
        return this.computeView(blob, pictureConversion, imageInfo, convert);
    }

    @Override
    public List<PictureView> computeViewsFor(Blob blob, List<PictureConversion> pictureConversions, boolean convert) {
        return this.computeViewsFor(blob, pictureConversions, null, convert);
    }

    @Override
    public List<PictureView> computeViewsFor(Blob blob, List<PictureConversion> pictureConversions, ImageInfo imageInfo, boolean convert) {
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            blob.setMimeType(this.getImageMimeType(blob));
        }
        if (imageInfo == null) {
            imageInfo = this.getImageInfo(blob);
        }
        ArrayList<PictureView> views = new ArrayList<PictureView>();
        for (PictureConversion pictureConversion : pictureConversions) {
            try {
                views.add(this.computeView(blob, pictureConversion, imageInfo, convert));
            }
            catch (NuxeoException e) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = pictureConversion::getId;
                supplierArray[1] = () -> ((NuxeoException)e).getMessage();
                log.warn("Unable to compute view: {} exception message: {}", supplierArray);
                log.debug((Object)e, (Throwable)e);
            }
        }
        return views;
    }

    protected PictureView computeView(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, boolean convert) {
        return this.computeView(null, blob, pictureConversion, imageInfo, convert);
    }

    protected PictureView computeView(DocumentModel doc, Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, boolean convert) {
        if (convert) {
            return this.computeView(doc, blob, pictureConversion, imageInfo);
        }
        return this.computeViewWithoutConversion(blob, pictureConversion, imageInfo);
    }

    protected Blob wrapBlob(Blob blob) {
        return new BlobWrapper(blob);
    }

    protected PictureView computeView(DocumentModel doc, Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo) {
        MimetypeRegistry mimetypeRegistry;
        List extensions;
        String conversionFormat;
        Blob viewBlob;
        String extension;
        String title = pictureConversion.getId();
        HashMap<String, Serializable> pictureViewMap = new HashMap<String, Serializable>();
        pictureViewMap.put("title", (Serializable)((Object)title));
        pictureViewMap.put("description", (Serializable)((Object)pictureConversion.getDescription()));
        pictureViewMap.put("tag", (Serializable)((Object)pictureConversion.getTag()));
        Point size = new Point(imageInfo.getWidth(), imageInfo.getHeight());
        if (pictureConversion.getMaxSize() != null) {
            size = ImageResizer.scaleToMax(size.x, size.y, pictureConversion.getMaxSize());
        }
        if (StringUtils.isEmpty((CharSequence)(extension = FilenameUtils.getExtension((String)(viewBlob = this.callPictureConversionChain(doc, blob, pictureConversion, imageInfo, size, conversionFormat = this.getConfigurationValue("conversionFormat", "jpg"))).getFilename()))) && (extensions = (mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class)).getExtensionsFromMimetypeName(viewBlob.getMimeType())) != null && !extensions.isEmpty()) {
            extension = (String)extensions.get(0);
        }
        String viewFilename = String.format("%s_%s.%s", title, FilenameUtils.getBaseName((String)blob.getFilename()), extension);
        viewBlob.setFilename(viewFilename);
        ImageInfo viewBlobImageInfo = this.getImageInfo(viewBlob);
        pictureViewMap.put("filename", (Serializable)((Object)viewFilename));
        pictureViewMap.put("content", (Serializable)viewBlob);
        pictureViewMap.put("info", viewBlobImageInfo);
        if (viewBlobImageInfo != null) {
            pictureViewMap.put("width", Integer.valueOf(viewBlobImageInfo.getWidth()));
            pictureViewMap.put("height", Integer.valueOf(viewBlobImageInfo.getHeight()));
        }
        return new PictureViewImpl(pictureViewMap);
    }

    protected Blob callPictureConversionChain(DocumentModel doc, Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo, Point size, String conversionFormat) {
        String chainId = pictureConversion.getChainId();
        if (StringUtils.isBlank((CharSequence)chainId)) {
            return this.wrapBlob(blob);
        }
        Properties parameters = new Properties();
        parameters.put((Object)"width", (Object)String.valueOf(size.x));
        parameters.put((Object)"height", (Object)String.valueOf(size.y));
        parameters.put((Object)"depth", (Object)String.valueOf(imageInfo.getDepth()));
        parameters.put((Object)"conversionFormat", (Object)conversionFormat);
        HashMap<String, Properties> chainParameters = new HashMap<String, Properties>();
        chainParameters.put("parameters", parameters);
        boolean txWasActive = false;
        try {
            Blob blob2;
            OperationContext context = new OperationContext();
            try {
                Blob viewBlob;
                if (doc != null) {
                    DocumentModel pictureDocument = doc.getCoreSession().getDocument(doc.getRef());
                    pictureDocument.detach(true);
                    context.put("pictureDocument", (Object)pictureDocument);
                }
                context.setInput((Object)blob);
                if (TransactionHelper.isTransactionActive()) {
                    txWasActive = true;
                    TransactionHelper.commitOrRollbackTransaction();
                }
                if ((viewBlob = (Blob)((AutomationService)Framework.getService(AutomationService.class)).run(context, chainId, chainParameters)) == null) {
                    viewBlob = this.wrapBlob(blob);
                }
                blob2 = viewBlob;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (OperationException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
            context.close();
            return blob2;
        }
        finally {
            if (txWasActive && !TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.startTransaction();
            }
        }
    }

    @Override
    public List<PictureView> computeViewsFor(DocumentModel doc, Blob blob, ImageInfo imageInfo, boolean convert) {
        List<PictureConversion> pictureConversions = this.getPictureConversions();
        ArrayList<PictureView> pictureViews = new ArrayList<PictureView>(pictureConversions.size());
        for (PictureConversion pictureConversion : pictureConversions) {
            if (!this.canApplyPictureConversion(pictureConversion, doc)) continue;
            try {
                PictureView pictureView = this.computeView(doc, blob, pictureConversion, imageInfo, convert);
                pictureViews.add(pictureView);
            }
            catch (NuxeoException e) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = pictureConversion::getId;
                supplierArray[1] = doc::toString;
                supplierArray[2] = () -> ((NuxeoException)e).getMessage();
                log.warn("Unable to compute view: {} for document: {} exception message: {}", supplierArray);
                log.debug((Object)e, (Throwable)e);
            }
        }
        return pictureViews;
    }

    protected boolean canApplyPictureConversion(PictureConversion pictureConversion, DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return actionService.checkFilters(pictureConversion.getFilterIds(), this.createActionContext(doc));
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        CoreSession coreSession = doc.getCoreSession();
        actionContext.setDocumentManager(coreSession);
        if (coreSession != null) {
            actionContext.setCurrentPrincipal(coreSession.getPrincipal());
        }
        return actionContext;
    }

    protected PictureView computeViewWithoutConversion(Blob blob, PictureConversion pictureConversion, ImageInfo imageInfo) {
        PictureViewImpl view = new PictureViewImpl();
        view.setBlob(blob);
        view.setWidth(imageInfo.getWidth());
        view.setHeight(imageInfo.getHeight());
        view.setFilename(blob.getFilename());
        view.setTitle(pictureConversion.getId());
        view.setDescription(pictureConversion.getDescription());
        view.setTag(pictureConversion.getTag());
        view.setImageInfo(imageInfo);
        return view;
    }

    @Deprecated
    protected static Point getSize(Point current, int max) {
        int newX;
        int newY;
        int x = current.x;
        int y = current.y;
        if (x > y) {
            newY = y * max / x;
            newX = max;
        } else {
            newX = x * max / y;
            newY = max;
        }
        if (newX > x || newY > y) {
            return current;
        }
        return new Point(newX, newY);
    }

    @Override
    public List<List<PictureView>> computeViewsFor(List<Blob> blobs, List<PictureConversion> pictureConversions, boolean convert) {
        return this.computeViewsFor(blobs, pictureConversions, null, convert);
    }

    @Override
    public List<List<PictureView>> computeViewsFor(List<Blob> blobs, List<PictureConversion> pictureConversions, ImageInfo imageInfo, boolean convert) {
        ArrayList<List<PictureView>> allViews = new ArrayList<List<PictureView>>();
        for (Blob blob : blobs) {
            allViews.add(this.computeViewsFor(blob, pictureConversions, imageInfo, convert));
        }
        return allViews;
    }
}

