/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.concurrent.Callable;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.storage.dbs.DBSCachingRepositoryFactory;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryFactory;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class DBSRepositoryService
extends DefaultComponent {
    protected static final String XP = "repositoryContributor";

    protected DBSRepositoryRegistry getDBSRegistry() {
        return (DBSRepositoryRegistry)this.getExtensionPointRegistry(XP);
    }

    public int getApplicationStartedOrder() {
        return 99;
    }

    public void start(ComponentContext context) {
        DBSRepositoryRegistry registry = this.getDBSRegistry();
        registry.getRepositoryContributors().forEach(desc -> this.updateRegistration(registry.getRepositoryDescriptor(desc.name), desc.factory));
    }

    protected void updateRegistration(DBSRepositoryDescriptor descriptor, Class<? extends DBSRepositoryFactory> factoryClass) {
        RepositoryFactory repositoryFactory;
        String repositoryName = descriptor.name;
        try {
            repositoryFactory = factoryClass.getConstructor(String.class).newInstance(repositoryName);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (descriptor.isCacheEnabled()) {
            repositoryFactory = new DBSCachingRepositoryFactory(repositoryName, repositoryFactory);
        }
        Repository repository = new Repository(repositoryName, descriptor.label, descriptor.isDefault(), descriptor.isHeadless(), (Callable)repositoryFactory, descriptor.pool);
        ((RepositoryManager)Framework.getService(RepositoryManager.class)).addRepository(repository);
    }

    public DBSRepositoryDescriptor getRepositoryDescriptor(String name) {
        return this.getDBSRegistry().getRepositoryDescriptor(name);
    }
}

