/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.actions.ActionDescriptor;

public class Action
implements Serializable,
Comparable<Action> {
    private static final long serialVersionUID = 1L;
    public static final String[] EMPTY_CATEGORIES = new String[0];
    protected final String id;
    protected String link;
    protected String label;
    protected String icon;
    protected String confirm = "";
    protected String help = "";
    protected boolean immediate;
    protected String accessKey;
    protected String type;
    protected Map<String, Serializable> properties = new HashMap<String, Serializable>();
    protected Map<String, Serializable> localProperties = new HashMap<String, Serializable>();
    protected boolean available = true;
    protected boolean filtered = false;
    protected int order = 0;
    protected List<String> categories = new ArrayList<String>();
    protected List<String> filterIds = new ArrayList<String>();

    @Deprecated(since="11.5")
    public Action() {
        this.id = "";
    }

    public Action(String id) {
        this.id = id;
    }

    @Deprecated(since="11.5")
    public Action(String id, String[] categories) {
        this(id);
        if (categories != null) {
            this.setCategories(Arrays.asList(categories));
        }
    }

    public Action(ActionDescriptor desc) {
        this(desc.getId());
        this.setLink(desc.getLink());
        this.setLabel(desc.getLabel() == null ? desc.getId() : desc.getLabel());
        this.setIcon(desc.getIcon());
        this.setConfirm(desc.getConfirm());
        this.setHelp(desc.getHelp());
        this.setImmediate(desc.isImmediate());
        this.setAccessKey(desc.getAccessKey());
        this.setType(desc.getType());
        this.properties.putAll(desc.getProperties());
        this.setOrder(desc.getOrder());
        this.setCategories(desc.getCategories());
        this.setFilterIds(desc.getAllFilterIds());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String[] getCategories() {
        return this.categories.toArray(new String[0]);
    }

    public List<String> getCategoryList() {
        return Collections.unmodifiableList(this.categories);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int compareTo(Action anotherAction) {
        int cmp = this.order - anotherAction.order;
        if (cmp == 0) {
            cmp = this.id.compareTo(anotherAction.id);
        }
        return cmp;
    }

    public List<String> getFilterIds() {
        return Collections.unmodifiableList(this.filterIds);
    }

    public void setFilterIds(List<String> filterIds) {
        this.filterIds.clear();
        this.filterIds.addAll(filterIds);
    }

    public void setCategories(List<String> categories) {
        this.categories.clear();
        this.categories.addAll(categories);
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String title) {
        this.help = title;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setProperties(Map<String, Serializable> localProperties) {
        this.localProperties.clear();
        this.localProperties.putAll(localProperties);
    }

    public Map<String, Serializable> getProperties() {
        HashMap<String, Serializable> res = new HashMap<String, Serializable>();
        res.putAll(this.properties);
        res.putAll(this.localProperties);
        return res;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    @Deprecated(since="11.5")
    public boolean isEnabled() {
        return this.getAvailable();
    }

    @Deprecated(since="11.5")
    public void setEnabled(boolean enabled) {
        this.setAvailable(enabled);
    }
}

