/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ActionService
extends DefaultComponent
implements ActionManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.actions.ActionService");
    private static final Logger log = LogManager.getFormatterLogger(ActionService.class);
    protected static final String ACTIONS_XP = "actions";
    protected static final String FILTERS_XP = "filters";
    protected static final String TYPE_COMPATIBILTIY_XP = "typeCompatibility";
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected static final String LOG_MIN_DURATION_KEY = "nuxeo.actions.debug.log_min_duration_ms";
    protected static final long DEFAULT_LOG_MIN_DURATION = Duration.ofMillis(-1L).toNanos();
    private long logMinDurationNanos = DEFAULT_LOG_MIN_DURATION;
    private Timer actionsTimer;
    private Timer actionTimer;
    private Timer filtersTimer;
    private Timer filterTimer;

    public void activate(ComponentContext context) {
        String mname1 = "nuxeo";
        String mname2 = "ActionService";
        this.actionsTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", ACTIONS_XP}));
        this.actionTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", "action"}));
        this.filtersTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", FILTERS_XP}));
        this.filterTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", "filter"}));
    }

    public void deactivate(ComponentContext context) {
        this.actionsTimer = null;
        this.actionTimer = null;
        this.filtersTimer = null;
        this.filterTimer = null;
    }

    public void start(ComponentContext context) {
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        long logMinDurationMillis = configurationService.getLong(LOG_MIN_DURATION_KEY, -1L);
        this.logMinDurationNanos = Duration.ofMillis(logMinDurationMillis).toNanos();
        ((ActionRegistry)this.getExtensionPointRegistry(ACTIONS_XP)).setTypeCompatibility(this.getRegistryContributions(TYPE_COMPATIBILTIY_XP));
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.logMinDurationNanos = DEFAULT_LOG_MIN_DURATION;
    }

    private void applyFilters(ActionContext context, List<Action> actions) {
        Iterator<Action> it = actions.iterator();
        while (it.hasNext()) {
            Action action = it.next();
            action.setFiltered(true);
            if (this.checkFilters(context, action)) continue;
            it.remove();
        }
    }

    @Override
    public boolean checkFilters(Action action, ActionContext context) {
        return this.checkFilters(context, action);
    }

    private boolean checkFilters(ActionContext context, Action action) {
        boolean granted;
        if (action == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("Checking access for action '%s'...", action.getId()));
        }
        if (granted = this.checkFilters(action, action.getFilterIds(), context)) {
            if (log.isTraceEnabled()) {
                log.trace(String.format("Granting access for action '%s'", action.getId()));
            }
        } else if (log.isTraceEnabled()) {
            log.trace(String.format("Denying access for action '%s'", action.getId()));
        }
        return granted;
    }

    @Override
    public List<Action> getActions(String category, ActionContext context) {
        return this.getActions(category, context, true);
    }

    @Override
    public List<Action> getAllActions(String category) {
        return this.getActionRegistry().getActions(category);
    }

    protected ActionRegistry getActionRegistry() {
        return (ActionRegistry)this.getExtensionPointRegistry(ACTIONS_XP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Action> getActions(String category, ActionContext context, boolean hideUnavailableActions) {
        ArrayList<Action> arrayList;
        List<Action> actions;
        Timer.Context timerContext;
        block7: {
            timerContext = this.actionsTimer.time();
            actions = this.getActionRegistry().getActions(category);
            if (!hideUnavailableActions) break block7;
            this.applyFilters(context, actions);
            List<Action> list = actions;
            long duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                log.printf(Level.DEBUG, "Resolving actions for category '%s' took: %(,.2f ms", new Object[]{category, (double)duration / 1000000.0});
            }
            return list;
        }
        try {
            ArrayList<Action> allActions = new ArrayList<Action>(actions);
            this.applyFilters(context, actions);
            for (Action a : allActions) {
                a.setAvailable(actions.contains(a));
            }
            arrayList = allActions;
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                log.printf(Level.DEBUG, "Resolving actions for category '%s' took: %(,.2f ms", new Object[]{category, (double)duration / 1000000.0});
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            log.printf(Level.DEBUG, "Resolving actions for category '%s' took: %(,.2f ms", new Object[]{category, (double)duration / 1000000.0});
        }
        return arrayList;
    }

    protected boolean isTimeTracerLogEnabled() {
        return log.isDebugEnabled() && this.logMinDurationNanos >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Action getAction(String actionId, ActionContext context, boolean hideUnavailableAction) {
        block7: {
            timerContext = this.actionTimer.time();
            try {
                action = this.getActionRegistry().getAction(actionId);
                if (action == null) ** GOTO lbl22
                if (!hideUnavailableAction) break block7;
                if (this.checkFilters(context, action)) ** GOTO lbl21
                var6_6 = null;
            }
            catch (Throwable var9_10) {
                duration = timerContext.stop();
                if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                    ActionService.log.printf(Level.DEBUG, "Resolving action with id '%s' took: %(,.2f ms", new Object[]{actionId, (double)duration / 1000000.0});
                }
                throw var9_10;
            }
            duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                ActionService.log.printf(Level.DEBUG, "Resolving action with id '%s' took: %(,.2f ms", new Object[]{actionId, (double)duration / 1000000.0});
            }
            return var6_6;
        }
        if (!this.checkFilters(context, action)) {
            action.setAvailable(false);
        }
lbl21:
        // 4 sources

        action.setFiltered(true);
lbl22:
        // 2 sources

        var6_7 = action;
        duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            ActionService.log.printf(Level.DEBUG, "Resolving action with id '%s' took: %(,.2f ms", new Object[]{actionId, (double)duration / 1000000.0});
        }
        return var6_7;
    }

    @Override
    public Action getAction(String actionId) {
        return this.getActionRegistry().getAction(actionId);
    }

    @Override
    public boolean isRegistered(String actionId) {
        return this.getActionRegistry().getAction(actionId) != null;
    }

    @Override
    public boolean isEnabled(String actionId, ActionContext context) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action != null) {
            return this.isEnabled(action, context);
        }
        return false;
    }

    public boolean isEnabled(Action action, ActionContext context) {
        MapRegistry filterReg = (MapRegistry)this.getExtensionPointRegistry(FILTERS_XP);
        for (String filterId : action.getFilterIds()) {
            Optional filter = filterReg.getContribution(filterId);
            if (!filter.isPresent() || ((ActionFilter)filter.get()).accept(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ActionFilter[] getFilters(String actionId) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action == null) {
            return null;
        }
        MapRegistry filterReg = (MapRegistry)this.getExtensionPointRegistry(FILTERS_XP);
        List<String> filterIds = action.getFilterIds();
        if (filterIds != null && !filterIds.isEmpty()) {
            ActionFilter[] filters = new ActionFilter[filterIds.size()];
            for (int i = 0; i < filters.length; ++i) {
                String filterId = filterIds.get(i);
                filters[i] = filterReg.getContribution(filterId).orElse(null);
            }
            return filters;
        }
        return null;
    }

    @Override
    public ActionFilter getFilter(String filterId) {
        return this.getRegistryContribution(FILTERS_XP, filterId).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkFilter(String filterId, ActionContext context) {
        boolean bl;
        Timer.Context timerContext = this.filterTimer.time();
        try {
            ActionFilter filter = this.getFilter(filterId);
            bl = filter != null && filter.accept(context);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                log.printf(Level.DEBUG, "Resolving filter with id '%s' took: %(,.2f ms", new Object[]{filterId, (double)duration / 1000000.0});
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            log.printf(Level.DEBUG, "Resolving filter with id '%s' took: %(,.2f ms", new Object[]{filterId, (double)duration / 1000000.0});
        }
        return bl;
    }

    @Override
    public boolean checkFilters(List<String> filterIds, ActionContext context) {
        return this.checkFilters(null, filterIds, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkFilters(Action action, List<String> filterIds, ActionContext context) {
        block10: {
            if (filterIds == null || filterIds.isEmpty()) {
                return true;
            }
            timerContext = this.filtersTimer.time();
            try {
                filterReg = (MapRegistry)this.getExtensionPointRegistry("filters");
lbl6:
                // 4 sources

                for (String filterId : filterIds) {
                    filter = filterReg.getContribution(filterId).orElse(null);
                    if (filter == null) continue;
                    if (!filter.accept(context)) {
                        if (ActionService.log.isTraceEnabled()) {
                            ActionService.log.trace("Filter '{}' denied access", (Object)filterId);
                        }
                        var9_11 = false;
                        break block10;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl29
            }
            catch (Throwable var12_13) {
                duration = timerContext.stop();
                if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                    ActionService.log.printf(Level.DEBUG, "Resolving filters '%s' took: %(,.2f ms", new Object[]{filterIds, (double)duration / 1000000.0});
                }
                throw var12_13;
            }
        }
        duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            ActionService.log.printf(Level.DEBUG, "Resolving filters '%s' took: %(,.2f ms", new Object[]{filterIds, (double)duration / 1000000.0});
        }
        return var9_11;
lbl-1000:
        // 1 sources

        {
            if (!ActionService.log.isTraceEnabled()) ** GOTO lbl6
            ActionService.log.trace(String.format("Filter '%s' granted access", new Object[]{filterId}));
            ** GOTO lbl6
lbl29:
            // 1 sources

            var6_7 = true;
        }
        duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            ActionService.log.printf(Level.DEBUG, "Resolving filters '%s' took: %(,.2f ms", new Object[]{filterIds, (double)duration / 1000000.0});
        }
        return var6_7;
    }

    @Override
    public void addAction(Action action) {
        this.getActionRegistry().addAction(action);
    }

    @Override
    public Action removeAction(String actionId) {
        return this.getActionRegistry().removeAction(actionId);
    }

    @Override
    public void remove() {
    }
}

