/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XMerge;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.FilterRule;

@XObject(value="filter")
@XRegistry(merge=false)
public class DefaultActionFilter
implements ActionFilter {
    private static final Logger log = LogManager.getLogger(DefaultActionFilter.class);
    @XNode(value="@id")
    @XRegistryId
    protected String id;
    @XNode(value="@merge", fallback="@append")
    @XMerge(defaultAssignment=false)
    protected boolean append;
    @XNodeList(value="rule", type=String[].class, componentType=FilterRule.class)
    protected FilterRule[] rules;
    public static final String PRECOMPUTED_KEY = "PrecomputedFilters";

    @Override
    public String getId() {
        return this.id;
    }

    public FilterRule[] getRules() {
        return this.rules;
    }

    @Override
    public boolean accept(ActionContext context) {
        if (log.isDebugEnabled()) {
            log.debug("#accept: checking filter '{}'", (Object)this.getId());
        }
        if (context == null) {
            if (log.isDebugEnabled()) {
                log.debug("#accept: no context available: action filtered");
            }
            return false;
        }
        if (this.rules == null || this.rules.length == 0) {
            return true;
        }
        boolean existsGrantRule = false;
        boolean grantApply = false;
        for (FilterRule rule : this.rules) {
            boolean ruleApplies = this.checkRule(rule, context);
            if (!rule.grant) {
                if (!ruleApplies) continue;
                if (log.isDebugEnabled()) {
                    log.debug("#accept: denying rule applies => action filtered");
                }
                return false;
            }
            existsGrantRule = true;
            if (!ruleApplies) continue;
            grantApply = true;
        }
        if (existsGrantRule) {
            if (log.isDebugEnabled()) {
                if (grantApply) {
                    log.debug("#accept: granting rule applies, action not filtered");
                } else {
                    log.debug("#accept: granting rule applies, action filtered");
                }
            }
            return grantApply;
        }
        return true;
    }

    protected final boolean checkRule(FilterRule rule, ActionContext context) {
        boolean result;
        Map precomputed;
        boolean disableCache;
        if (log.isDebugEnabled()) {
            log.debug("#checkRule: checking rule '{}'", (Object)rule);
        }
        if (!(disableCache = context.disableGlobalCaching()) && (precomputed = (Map)context.getLocalVariable(PRECOMPUTED_KEY)) != null && precomputed.containsKey(rule)) {
            if (log.isDebugEnabled()) {
                log.debug("#checkRule: return precomputed result for rule '{}'", (Object)rule);
            }
            return Boolean.TRUE.equals(precomputed.get(rule));
        }
        boolean bl = result = !(rule.facets != null && rule.facets.length != 0 && !this.checkFacets(context, rule.facets) || rule.types != null && rule.types.length != 0 && !this.checkTypes(context, rule.types) || rule.schemas != null && rule.schemas.length != 0 && !this.checkSchemas(context, rule.schemas) || rule.permissions != null && rule.permissions.length != 0 && !this.checkPermissions(context, rule.permissions) || rule.groups != null && rule.groups.length != 0 && !this.checkGroups(context, rule.groups) || rule.conditions != null && rule.conditions.length != 0 && !this.checkConditions(context, rule.conditions));
        if (!disableCache) {
            HashMap<FilterRule, Boolean> precomputed2 = (HashMap<FilterRule, Boolean>)context.getLocalVariable(PRECOMPUTED_KEY);
            if (precomputed2 == null) {
                precomputed2 = new HashMap<FilterRule, Boolean>();
                context.putLocalVariable(PRECOMPUTED_KEY, precomputed2);
            }
            precomputed2.put(rule, result);
        }
        return result;
    }

    protected final boolean checkFacets(ActionContext context, String[] facets) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            return false;
        }
        for (String facet : facets) {
            if (!doc.hasFacet(facet)) continue;
            if (log.isDebugEnabled()) {
                log.debug("#checkFacets: return true for facet '{}'", (Object)facet);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("#checkFacets: return false");
        }
        return false;
    }

    protected final boolean checkPermissions(ActionContext context, String[] permissions) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            NuxeoPrincipal principal = context.getCurrentPrincipal();
            if (principal != null && principal.isAdministrator()) {
                if (log.isDebugEnabled()) {
                    log.debug("#checkPermissions: doc is null but user is admin => return true");
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("#checkPermissions: doc and user are null => return false");
            }
            return false;
        }
        CoreSession docMgr = context.getDocumentManager();
        if (docMgr == null) {
            if (log.isDebugEnabled()) {
                log.debug("#checkPermissions: no core session => return false");
            }
            return false;
        }
        for (String permission : permissions) {
            if (!docMgr.hasPermission(doc.getRef(), permission)) continue;
            if (log.isDebugEnabled()) {
                log.debug("#checkPermissions: return true for permission '{}'", (Object)permission);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("#checkPermissions: return false");
        }
        return false;
    }

    protected final boolean checkGroups(ActionContext context, String[] groups) {
        NuxeoPrincipal principal = context.getCurrentPrincipal();
        if (principal == null) {
            if (log.isDebugEnabled()) {
                log.debug("#checkGroups: no user => return false");
            }
            return false;
        }
        for (String group : groups) {
            if (!principal.isMemberOf(group)) continue;
            if (log.isDebugEnabled()) {
                log.debug("#checkGroups: return true for group '{}'", (Object)group);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("#checkGroups: return false");
        }
        return false;
    }

    protected final boolean checkConditions(ActionContext context, String[] conditions) {
        for (String condition : conditions) {
            try {
                if (!context.checkCondition(condition)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("#checkCondition: return true for condition '{}'", (Object)condition);
                }
                return true;
            }
            catch (ELException e) {
                log.error("Evaluation of condition '{}' failed: returning false", (Object)condition, (Object)e);
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("#checkConditions: return false");
        }
        return false;
    }

    protected final boolean checkTypes(ActionContext context, String[] types) {
        DocumentModel doc = context.getCurrentDocument();
        String docType = doc == null ? "Root" : doc.getType();
        for (String type : types) {
            if (!type.equals(docType)) continue;
            if (log.isDebugEnabled()) {
                log.debug("#checkTypes: return true for type '{}'", (Object)docType);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("#checkTypes: return false");
        }
        return false;
    }

    protected final boolean checkSchemas(ActionContext context, String[] schemas) {
        DocumentModel doc = context.getCurrentDocument();
        if (doc == null) {
            if (log.isDebugEnabled()) {
                log.debug("#checkSchemas: no doc => return false");
            }
            return false;
        }
        for (String schema : schemas) {
            if (!doc.hasSchema(schema)) continue;
            if (log.isDebugEnabled()) {
                log.debug("#checkSchemas: return true for schema '{}'", (Object)schema);
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("#checkSchemas: return false");
        }
        return false;
    }
}

