/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.nuxeo.common.codec.CryptoProperties;

public class ConfigurationHolder {
    protected static final List<String> DB_LIST = Arrays.asList("default", "mongodb", "postgresql", "oracle", "mysql", "mariadb", "mssql", "db2");
    protected static final Set<String> DIRECTORY_PARAMETERS = Set.of("nuxeo.config.dir", "nuxeo.data.dir", "nuxeo.log.dir", "nuxeo.mp.dir", "nuxeo.pid.dir", "nuxeo.tmp.dir");
    protected static final Path LOG4J2_CONF = Path.of("lib", "log4j2.xml");
    protected static final Path NXSERVER = Path.of("nxserver", new String[0]);
    protected static final Path TEMPLATES = Path.of("templates", new String[0]);
    protected final Path home;
    protected final Path nuxeoConf;
    protected final Properties defaultConfig;
    protected final CryptoProperties userConfig;
    protected final List<Path> templates;

    public ConfigurationHolder(Path home, Path nuxeoConf) {
        this.home = Objects.requireNonNull(home).toAbsolutePath();
        this.nuxeoConf = Objects.requireNonNull(nuxeoConf).toAbsolutePath();
        Properties basicConfig = new Properties();
        UnaryOperator homeResolver = k -> this.getHomePath().resolve((String)k).toString();
        UnaryOperator runtimeResolver = k -> this.getRuntimeHomePath().resolve((String)k).toString();
        basicConfig.put("nuxeo.config.dir", runtimeResolver.apply("config"));
        basicConfig.put("nuxeo.data.dir", runtimeResolver.apply("data"));
        basicConfig.put("nuxeo.log.dir", homeResolver.apply("log"));
        basicConfig.put("nuxeo.mp.dir", homeResolver.apply("packages"));
        basicConfig.put("nuxeo.pid.dir", homeResolver.apply("log"));
        basicConfig.put("nuxeo.tmp.dir", homeResolver.apply("tmp"));
        this.defaultConfig = new Properties(basicConfig);
        this.userConfig = new CryptoProperties(this.defaultConfig);
        this.templates = new ArrayList<Path>();
    }

    public Path getHomePath() {
        return this.home;
    }

    public Path getNuxeoConfPath() {
        return this.nuxeoConf;
    }

    public Path getTemplatesPath() {
        return this.home.resolve(TEMPLATES);
    }

    public Path getRuntimeHomePath() {
        return this.home.resolve(NXSERVER);
    }

    public Path getConfigurationPath() {
        return this.getPropertyAsPath("nuxeo.config.dir");
    }

    public Path getDataPath() {
        return this.getPropertyAsPath("nuxeo.data.dir");
    }

    public Path getDumpedConfigurationPath() {
        return this.getConfigurationPath().resolve("configuration.properties");
    }

    public Path getLogPath() {
        return this.getPropertyAsPath("nuxeo.log.dir");
    }

    public Path getLogConfigPath() {
        return this.getHomePath().resolve(LOG4J2_CONF);
    }

    protected Path getPackagesPath() {
        return this.getPropertyAsPath("nuxeo.mp.dir");
    }

    public Path getPidDirPath() {
        return this.getPropertyAsPath("nuxeo.pid.dir");
    }

    protected Path getTmpPath() {
        return this.getPropertyAsPath("nuxeo.tmp.dir");
    }

    public boolean isLoaded() {
        return !this.userConfig.isEmpty();
    }

    public String getDefaultProperty(String key) {
        return this.defaultConfig.getProperty(key);
    }

    public String getProperty(String key) {
        return this.userConfig.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.userConfig.getProperty(key, defaultValue);
    }

    public Optional<String> getOptProperty(String key) {
        return Optional.ofNullable(this.userConfig.getProperty(key));
    }

    public boolean getPropertyAsBoolean(String key) {
        return Boolean.parseBoolean(this.getProperty(key, "false"));
    }

    public int getPropertyAsInteger(String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public Path getPropertyAsPath(String key) {
        return Path.of(this.getProperty(key), new String[0]);
    }

    public String getRawProperty(String key) {
        return this.userConfig.getRawProperty(key);
    }

    public Set<String> keySet() {
        return this.userConfig.keySet();
    }

    public Set<String> stringPropertyNames() {
        return this.userConfig.stringPropertyNames();
    }

    public boolean isForceGenerationOnce() {
        return "once".equals(this.userConfig.getProperty("nuxeo.force.generation"));
    }

    public boolean isForceGeneration() {
        return this.isForceGenerationOnce() || "true".equals(this.userConfig.getProperty("nuxeo.force.generation"));
    }

    public String putDefault(String key, String value) {
        return (String)this.defaultConfig.put(key, this.makePathAbsolute(key, value));
    }

    public void putDefaultAll(Properties properties) {
        this.defaultConfig.putAll((Map<?, ?>)this.makePathAbsolute(properties));
    }

    public String put(String key, String value) {
        return (String)this.userConfig.put((Object)key, (Object)this.makePathAbsolute(key, value));
    }

    public void putAll(Properties properties) {
        this.userConfig.putAll((Map)this.makePathAbsolute(properties));
    }

    public void putTemplateAll(Path template, Properties properties) {
        this.templates.add(template);
        this.defaultConfig.putAll((Map<?, ?>)this.makePathAbsolute(properties));
    }

    protected Properties makePathAbsolute(Properties properties) {
        properties.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, Object>)(k, v) -> this.makePathAbsolute((String)k, (String)v)));
        return properties;
    }

    protected String makePathAbsolute(String key, String value) {
        if (DIRECTORY_PARAMETERS.contains(key)) {
            return this.home.resolve(value).toString();
        }
        return value;
    }

    public List<Path> getIncludedTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public List<String> getIncludedTemplateNames() {
        return this.templates.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toUnmodifiableList());
    }

    public String getIncludedDBTemplateName() {
        return this.templates.stream().map(Path::getFileName).map(Path::toString).filter(DB_LIST::contains).reduce("unknown", (first, second) -> second);
    }

    protected void clear() {
        this.defaultConfig.clear();
        this.userConfig.clear();
        this.templates.clear();
    }
}

