/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BundleIdGenerator {
    private static final Log log = LogFactory.getLog(BundleIdGenerator.class);
    private final Map<String, Long> ids = new HashMap<String, Long>();
    private long count = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(File file) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.count = ((DataInputStream)in).readLong();
            int size = ((DataInputStream)in).readInt();
            for (int i = 0; i < size; ++i) {
                String key = ((DataInputStream)in).readUTF();
                long id = ((DataInputStream)in).readLong();
                this.ids.put(key, id);
            }
        }
        catch (FileNotFoundException size) {
        }
        catch (IOException e) {
            file.delete();
            log.error((Object)"The bundle.ids file is corrupted. reseting bundle ids.");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(File file) throws IOException {
        try (FilterOutputStream out = null;){
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            ((DataOutputStream)out).writeLong(this.count);
            int size = this.ids.size();
            ((DataOutputStream)out).writeInt(size);
            for (Map.Entry<String, Long> entry : this.ids.entrySet()) {
                ((DataOutputStream)out).writeUTF(entry.getKey());
                ((DataOutputStream)out).writeLong(entry.getValue());
            }
        }
    }

    public synchronized long getBundleId(String name) {
        Long id = this.ids.get(name);
        if (id == null) {
            id = this.count++;
            this.ids.put(name, id);
        }
        return id;
    }

    public synchronized long addBundle(String name) {
        long id = this.count++;
        this.ids.put(name, id);
        return id;
    }

    public synchronized boolean contains(String name) {
        return this.ids.containsKey(name);
    }
}

