/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Manifest;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleManifestReader;
import org.nuxeo.osgi.NullActivator;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.OSGiBundleContext;
import org.nuxeo.osgi.util.CompoundEnumeration;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleImpl
implements Bundle {
    protected final long id;
    protected final String symbolicName;
    protected final Dictionary<String, String> headers;
    protected final BundleContext context;
    protected final OSGiAdapter osgi;
    protected final BundleFile file;
    protected final String location;
    protected final ClassLoader loader;
    protected int state;
    protected long lastModified;
    protected BundleActivator activator;
    protected double startupTime;
    protected boolean allowHostOverride;

    public BundleImpl(OSGiAdapter osgi, BundleFile file, ClassLoader loader) throws BundleException {
        this(osgi, file, loader, false);
    }

    public BundleImpl(OSGiAdapter osgi, BundleFile file, ClassLoader loader, boolean isSystemBundle) throws BundleException {
        this.osgi = osgi;
        this.loader = loader;
        this.file = file;
        this.location = file.getLocation();
        Manifest mf = file.getManifest();
        if (mf == null) {
            this.headers = null;
            this.symbolicName = null;
            this.id = -1L;
            this.context = null;
            return;
        }
        try {
            this.headers = BundleManifestReader.getHeaders(mf);
        }
        catch (BundleException e) {
            throw new BundleException("Invalid OSGi Manifest in file " + file + " : " + e.getMessage(), (Throwable)e);
        }
        this.symbolicName = this.headers.get("Bundle-SymbolicName");
        this.allowHostOverride = Boolean.parseBoolean(this.headers.get("Nuxeo-AllowOverride"));
        this.id = isSystemBundle ? 0L : osgi.getBundleId(this.symbolicName);
        this.context = this.createContext();
        this.state = 1;
    }

    public BundleFile getBundleFile() {
        return this.file;
    }

    protected final BundleContext createContext() {
        return new OSGiBundleContext(this);
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start(int options) throws BundleException {
    }

    public void stop(int options) throws BundleException {
    }

    public String getLocation() {
        return this.location;
    }

    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.loader.getResources(name);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    public URL getEntry(String name) {
        return this.file.getEntry(name);
    }

    public static PackageAdmin getPackageAdmin() {
        BundleContext sysctx = Framework.getRuntime().getContext().getBundle().getBundleContext();
        ServiceReference ref = sysctx.getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)sysctx.getService(ref);
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        Enumeration<URL> hostEntries = this.file.findEntries(path, filePattern, recurse);
        BundleImpl[] fragments = this.osgi.getRegistry().getFragments(this.symbolicName);
        if (fragments.length == 0) {
            return hostEntries;
        }
        CompoundEnumerationBuilder builder = new CompoundEnumerationBuilder();
        if (!this.allowHostOverride) {
            builder.add(hostEntries);
        }
        for (BundleImpl fragment : fragments) {
            Enumeration fragmentEntries = fragment.findEntries(path, filePattern, recurse);
            builder.add(fragmentEntries);
        }
        if (this.allowHostOverride) {
            builder.add(hostEntries);
        }
        return builder.build();
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.file.getEntryPaths(path);
    }

    public long getBundleId() {
        return this.id;
    }

    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.headers;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public ServiceReference[] getRegisteredServices() {
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        return null;
    }

    public int getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public boolean hasPermission(Object permission) {
        return true;
    }

    protected String getActivatorClassName() {
        return this.headers == null ? null : this.headers.get("Bundle-Activator");
    }

    public BundleActivator getActivator() throws BundleException {
        if (this.activator == null) {
            this.activator = NullActivator.INSTANCE;
            String className = this.getActivatorClassName();
            if (className == null) {
                return this.activator;
            }
            try {
                this.activator = (BundleActivator)this.loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new BundleException("Activator not found: " + className, (Throwable)e);
            }
            catch (ReflectiveOperationException e) {
                throw new BundleException("Activator not instantiable: " + className, (Throwable)e);
            }
        }
        return this.activator;
    }

    public void start() throws BundleException {
        try {
            this.setStarting();
            this.getActivator().start(this.context);
            this.setStarted();
        }
        catch (BundleException e) {
            throw new BundleException("Failed to start bundle at: " + this.file + " with activator: " + this.getActivatorClassName(), (Throwable)e);
        }
        catch (Exception e) {
            RuntimeException re = ExceptionUtils.runtimeException((Exception)e);
            throw new BundleException("Failed to start bundle at: " + this.file + " with activator: " + this.getActivatorClassName(), (Throwable)re);
        }
    }

    public void stop() throws BundleException {
        try {
            this.setStopping();
            this.getActivator().stop(this.context);
            this.setStopped();
        }
        catch (BundleException e) {
            throw new BundleException("Failed to stop activator: " + this.getActivatorClassName(), (Throwable)e);
        }
        catch (Exception e) {
            RuntimeException re = ExceptionUtils.runtimeException((Exception)e);
            throw new BundleException("Failed to stop activator: " + this.getActivatorClassName(), (Throwable)re);
        }
    }

    public void shutdown() throws BundleException {
        try {
            this.state = 16;
            this.getActivator().stop(this.context);
            this.lastModified = System.currentTimeMillis();
            this.state = 1;
        }
        catch (BundleException e) {
            throw new BundleException("Failed to stop activator: " + this.getActivatorClassName(), (Throwable)e);
        }
        catch (Exception e) {
            RuntimeException re = ExceptionUtils.runtimeException((Exception)e);
            throw new BundleException("Failed to stop activator: " + this.getActivatorClassName(), (Throwable)re);
        }
    }

    public void uninstall() throws BundleException {
        this.osgi.uninstall(this);
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw new BundleException("Cannot close underlying file resources " + this.symbolicName, (Throwable)e);
        }
    }

    public void update() throws BundleException {
        this.lastModified = System.currentTimeMillis();
        throw new UnsupportedOperationException("Bundle.update() operations was not yet implemented");
    }

    public void update(InputStream in) throws BundleException {
        this.lastModified = System.currentTimeMillis();
        throw new UnsupportedOperationException("Bundle.update() operations was not yet implemented");
    }

    void setInstalled() {
        if (this.state == 2) {
            return;
        }
        this.lastModified = System.currentTimeMillis();
        this.state = 2;
        BundleEvent event = new BundleEvent(1, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setUninstalled() {
        if (this.state == 1) {
            return;
        }
        this.lastModified = System.currentTimeMillis();
        this.state = 1;
        BundleEvent event = new BundleEvent(16, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setResolved() {
        if (this.state == 4) {
            return;
        }
        this.state = 4;
        BundleEvent event = new BundleEvent(32, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setUnResolved() {
        this.state = 2;
        BundleEvent event = new BundleEvent(64, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStarting() {
        if (this.state != 4) {
            return;
        }
        this.state = 8;
        BundleEvent event = new BundleEvent(128, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStarted() {
        if (this.state != 8) {
            return;
        }
        this.state = 32;
        BundleEvent event = new BundleEvent(2, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStopping() {
        if (this.state != 32) {
            return;
        }
        this.state = 16;
        BundleEvent event = new BundleEvent(256, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStopped() {
        if (this.state != 16) {
            return;
        }
        this.state = 4;
        BundleEvent event = new BundleEvent(4, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    public double getStartupTime() {
        return this.startupTime;
    }

    public int hashCode() {
        return this.symbolicName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bundle) {
            return this.symbolicName.equals(((Bundle)obj).getSymbolicName());
        }
        return false;
    }

    public int compareTo(Bundle obj) {
        return this.symbolicName.compareTo(obj.getSymbolicName());
    }

    public String toString() {
        return this.symbolicName;
    }

    public Map getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Version getVersion() {
        return Version.parseVersion((String)this.headers.get("Bundle-Version"));
    }

    public <A> A adapt(Class<A> type) {
        throw new UnsupportedOperationException();
    }

    public File getDataFile(String filename) {
        throw new UnsupportedOperationException();
    }

    protected static class CompoundEnumerationBuilder {
        protected final ArrayList<Enumeration<URL>> collected = new ArrayList();

        protected CompoundEnumerationBuilder() {
        }

        public CompoundEnumerationBuilder add(Enumeration<URL> e) {
            this.collected.add(e);
            return this;
        }

        public Enumeration<URL> build() {
            return new CompoundEnumeration<URL>(this.collected.toArray(new Enumeration[this.collected.size()]));
        }
    }
}

