/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ThumbnailHelper {
    private static final Logger log = LogManager.getLogger(ThumbnailHelper.class);
    public static final String THUMBNAIL_TX_TIMEOUT_PROPERTY = "nuxeo.thumbnail.transaction.timeout.seconds";
    public static final int DEFAULT_TX_TIMEOUT_SECONDS = 300;
    protected Integer transactionTimeout;

    public void createThumbnailIfNeeded(CoreSession session, DocumentModel doc) {
        Blob thumbnailBlob = this.getManagedThumbnail(doc);
        if (thumbnailBlob != null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Found a managed thumbnail for doc: {}", supplierArray);
        } else {
            ThumbnailAdapter thumbnailAdapter = (ThumbnailAdapter)doc.getAdapter(ThumbnailAdapter.class);
            if (thumbnailAdapter == null) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getId();
                log.debug("No thumbnail adapter for doc: {}, skipping", supplierArray);
                return;
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            supplierArray[1] = TransactionHelper::getTransactionTimeToLive;
            log.debug("Fetching or building a thumbnail for doc: {}, session ttl: {}s", supplierArray);
            thumbnailBlob = thumbnailAdapter.computeThumbnail(session);
        }
        boolean forceUpdate = false;
        if (thumbnailBlob == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Failed to create thumbnail for doc: {}", supplierArray);
            if (doc.hasFacet("Thumbnail")) {
                doc.removeFacet("Thumbnail");
                Supplier[] supplierArray2 = new Supplier[1];
                supplierArray2[0] = () -> ((DocumentModel)doc).getId();
                log.debug("Removing thumbnail facet from doc: {}", supplierArray2);
            }
            forceUpdate = true;
        } else {
            if (!doc.hasFacet("Thumbnail")) {
                doc.addFacet("Thumbnail");
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getId();
                log.debug("Adding thumbnail facet to doc: {}", supplierArray);
            }
            doc.setPropertyValue("thumb:thumbnail", (Serializable)thumbnailBlob);
        }
        if (forceUpdate || doc.isDirty()) {
            doc.putContextData("VersioningOption", (Serializable)VersioningOption.NONE);
            doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
            doc.putContextData("disableDublinCoreListener", (Serializable)Boolean.TRUE);
            doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            doc.putContextData("thumbnailUpdated", (Serializable)Boolean.valueOf(true));
            session.saveDocument(doc);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.debug("Thumbnail updated for doc: {}", supplierArray);
        }
    }

    public void newTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        log.debug("Commit and start transaction with timeout {}s", new Supplier[]{this::getTransactionTimeout});
        TransactionHelper.startTransaction((int)this.getTransactionTimeout());
    }

    public int getTransactionTimeout() {
        if (this.transactionTimeout == null) {
            String maxDurationStr = Framework.getProperty((String)THUMBNAIL_TX_TIMEOUT_PROPERTY, (String)String.valueOf(300));
            this.transactionTimeout = Integer.parseInt(maxDurationStr);
        }
        return this.transactionTimeout;
    }

    protected Blob getManagedThumbnail(DocumentModel doc) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            return null;
        }
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        try {
            InputStream is = blobManager.getThumbnail(blob);
            if (is == null) {
                return null;
            }
            return Blobs.createBlob((InputStream)is);
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to get managed blob thumbnail", (Throwable)e);
        }
    }
}

