/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.thumbnail.listener;

import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.DeletedDocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.thumbnail.ThumbnailConstants;
import org.nuxeo.ecm.platform.thumbnail.listener.ThumbnailHelper;

public class UpdateThumbnailListener
implements PostCommitEventListener {
    private static final Logger log = LogManager.getLogger(UpdateThumbnailListener.class);
    public static final String THUMBNAIL_UPDATED = "thumbnailUpdated";
    protected ThumbnailHelper thumbnailHelper = new ThumbnailHelper();

    protected void processDoc(CoreSession session, DocumentModel doc) {
        this.thumbnailHelper.createThumbnailIfNeeded(session, doc);
    }

    public void handleEvent(EventBundle events) {
        if (!events.containsEventName(ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name())) {
            return;
        }
        HashSet<String> processedDocs = new HashSet<String>();
        for (Event event : events) {
            if (!ThumbnailConstants.EventNames.scheduleThumbnailUpdate.name().equals(event.getName())) continue;
            DocumentEventContext context = (DocumentEventContext)event.getContext();
            DocumentModel doc = context.getSourceDocument();
            if (Boolean.TRUE.equals(context.getProperty("disableThumbnailComputation"))) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((DocumentModel)doc).getId();
                log.trace("Thumbnail computation is disabled for document {}", supplierArray);
                continue;
            }
            if (doc instanceof DeletedDocumentModel || doc.isProxy() || processedDocs.contains(doc.getId())) continue;
            this.thumbnailHelper.newTransaction();
            CoreSession repo = context.getCoreSession();
            this.processDoc(repo, doc);
            processedDocs.add(doc.getId());
        }
    }
}

