/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRemoteGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.text.PDFTextStripperByArea;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.LinkInfo;
import org.nuxeo.ecm.platform.pdf.PDFUtils;

public class PDFLinks {
    private Blob pdfBlob;
    private PDDocument pdfDoc;
    private String password;
    private List<LinkInfo> remoteGoToLinks;
    private List<LinkInfo> launchLinks;
    private List<LinkInfo> uriLinks;
    private PDFTextStripperByArea stripper;

    public PDFLinks(Blob inBlob) {
        this.pdfBlob = inBlob;
    }

    public void close() {
        PDFUtils.closeSilently(this.pdfDoc);
        this.pdfDoc = null;
        this.pdfBlob = null;
        this.password = null;
        this.remoteGoToLinks = null;
        this.launchLinks = null;
        this.stripper = null;
    }

    private void loadAndPreflightPdf() throws NuxeoException {
        if (this.pdfDoc != null) {
            return;
        }
        this.pdfDoc = PDFUtils.load(this.pdfBlob, this.password);
        try {
            this.stripper = new PDFTextStripperByArea();
            for (PDPage page : this.pdfDoc.getDocumentCatalog().getPages()) {
                List pageAnnotations = page.getAnnotations();
                for (Object annotationObject : pageAnnotations) {
                    PDAnnotation annot = (PDAnnotation)annotationObject;
                    if (!(annot instanceof PDAnnotationLink)) continue;
                    PDAnnotationLink link = (PDAnnotationLink)annot;
                    PDRectangle rect = link.getRectangle();
                    float x = rect.getLowerLeftX();
                    float y = rect.getUpperRightY();
                    float width = rect.getWidth();
                    float height = rect.getHeight();
                    int rotation = page.getRotation();
                    if (rotation == 0) {
                        PDRectangle pageSize = page.getMediaBox();
                        y = pageSize.getHeight() - y;
                    }
                    Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                    this.stripper.addRegion(String.valueOf(pageAnnotations.indexOf(annot)), (Rectangle2D)awtRect);
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot preflight and prepare regions", (Throwable)e);
        }
    }

    public List<LinkInfo> getRemoteGoToLinks() throws IOException {
        if (this.remoteGoToLinks == null) {
            this.loadAndPreflightPdf();
            this.remoteGoToLinks = this.parseForLinks("GoToR");
        }
        return this.remoteGoToLinks;
    }

    public List<LinkInfo> getLaunchLinks() throws IOException {
        if (this.launchLinks == null) {
            this.loadAndPreflightPdf();
            this.launchLinks = this.parseForLinks("Launch");
        }
        return this.launchLinks;
    }

    public List<LinkInfo> getURILinks() throws IOException {
        if (this.uriLinks == null) {
            this.loadAndPreflightPdf();
            this.uriLinks = this.parseForLinks("URI");
        }
        return this.uriLinks;
    }

    private List<LinkInfo> parseForLinks(String inSubType) throws IOException {
        ArrayList<LinkInfo> li = new ArrayList<LinkInfo>();
        int pageno = 0;
        for (PDPage page : this.pdfDoc.getDocumentCatalog().getPages()) {
            ++pageno;
            this.stripper.extractRegions(page);
            List annotations = page.getAnnotations();
            for (PDAnnotation annot : annotations) {
                PDAnnotationLink link;
                PDAction action;
                if (!(annot instanceof PDAnnotationLink) || !(action = (link = (PDAnnotationLink)annot).getAction()).getSubType().equals(inSubType)) continue;
                String urlText = this.stripper.getTextForRegion(String.valueOf(annotations.indexOf(annot)));
                String urlValue = null;
                switch (inSubType) {
                    case "GoToR": {
                        PDActionRemoteGoTo goTo = (PDActionRemoteGoTo)action;
                        PDFileSpecification fspec = goTo.getFile();
                        urlValue = fspec.getFile();
                        break;
                    }
                    case "Launch": {
                        PDActionLaunch launch = (PDActionLaunch)action;
                        PDFileSpecification fspec = launch.getFile();
                        urlValue = fspec.getFile();
                        break;
                    }
                    case "URI": {
                        PDActionURI uri = (PDActionURI)action;
                        urlValue = uri.getURI();
                    }
                }
                if (!StringUtils.isNotBlank(urlValue)) continue;
                li.add(new LinkInfo(pageno, inSubType, urlText, urlValue));
            }
        }
        return li;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

