/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event;

import java.time.Duration;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class EventServiceComponent
extends DefaultComponent {
    public static final int APPLICATION_STARTED_ORDER = -500;
    public static final String NAME = "org.nuxeo.ecm.core.event.EventServiceComponent";
    public static final String EVENT_LISTENER_XP = "listener";
    public static final String EVENT_PIPE_XP = "pipe";
    public static final String EVENT_DISPATCHER_XP = "dispatcher";
    public static final String DOMAIN_EVENT_PRODUCER_XP = "domainEventProducer";
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = Duration.ofSeconds(5L).toMillis();
    protected EventServiceImpl service;

    public void activate(ComponentContext context) {
        this.service = new EventServiceImpl();
    }

    public void applicationStarted(ComponentContext context) {
        this.service.init();
    }

    public void deactivate(ComponentContext context) {
        if (this.service != null) {
            String s = Framework.getProperty((String)"org.nuxeo.ecm.core.event.shutdown.timeoutMillis");
            long timeout = s == null ? DEFAULT_SHUTDOWN_TIMEOUT : Long.parseLong(s);
            try {
                this.service.shutdown(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            this.service = null;
        }
    }

    public int getApplicationStartedOrder() {
        return -500;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (EventService.class == adapter || EventProducer.class == adapter || EventServiceAdmin.class == adapter) {
            return (T)this.service;
        }
        return null;
    }
}

